//integer debug = FALSE;

integer sensetimer = 2;
integer timeout = 3;
float distance= 5;
integer white = FALSE;
integer counter;

//DEBUG( string msg) {
//    if (debug)
//        llSay(0,msg);
//}

// Mask Flags - set to TRUE to enable
integer glow = TRUE;            // Make the particles glow
integer bounce = FALSE;          // Make particles bounce on Z plan of object
integer interpColor = TRUE;     // Go from start to end color
integer interpSize = TRUE;      // Go from start to end size
integer wind = FALSE;           // Particles effected by wind
integer followSource = TRUE;    // Particles follow the source
integer followVel = TRUE;       // Particles turn to velocity direction

// Choose a pattern from the following:
// PSYS_SRC_PATTERN_EXPLODE
// PSYS_SRC_PATTERN_DROP
// PSYS_SRC_PATTERN_ANGLE_CONE_EMPTY
// PSYS_SRC_PATTERN_ANGLE_CONE
// PSYS_SRC_PATTERN_ANGLE
integer pattern = PSYS_SRC_PATTERN_ANGLE_CONE;


// Particle paramaters
float age = 2;                  // Life of each particle <-- invcease that value for larger fog
float maxSpeed = .1;            // Max speed each particle is spit out at
float minSpeed = .1;            // Min speed each particle is spit out at

float startAlpha = 1.0;           // Start alpha (transparency) value
float endAlpha = 0.05;           // End alpha (transparency) value
vector startSize = <2, 2, 2>;     // Start size of particles 
vector endSize = <2.0,2.0,0.0>;       // End size of particles (if interpSize == TRUE)
vector push = <0,0,0>;          // Force pushed on particles

// System paramaters
float rate = .5;            // How fast (rate) to emit particles
float radius = 1;          // Radius to emit particles for BURST pattern
////////////////////////////////////////////////////////////////////
integer count = 20;        // How many particles to emit per BURST <-- increase that value for more tense fog
////////////////////////////////////////////////////////////////////
float outerAngle = 1.57;    // Outer angle for all ANGLE patterns
float innerAngle = 1.58;    // Inner angle for all ANGLE patterns
vector omega = <0,0,1>;    // Rotation of ANGLE patterns around the source
float life = 0;             // Life in seconds for the system to make particles

// Script variables
integer flags;

FOGParticles(vector startColor, vector endColor)
{
    //DEBUG("Fog:" + (string) startColor);
    
    if (glow) flags = flags | PSYS_PART_EMISSIVE_MASK;
    if (bounce) flags = flags | PSYS_PART_BOUNCE_MASK;
    if (interpColor) flags = flags | PSYS_PART_INTERP_COLOR_MASK;
    if (interpSize) flags = flags | PSYS_PART_INTERP_SCALE_MASK;
    if (followSource) flags = flags | PSYS_PART_FOLLOW_SRC_MASK;
    if (followVel) flags = flags | PSYS_PART_FOLLOW_VELOCITY_MASK;
    

    llParticleSystem([  PSYS_PART_MAX_AGE,age,
                        PSYS_PART_FLAGS,flags,
                        PSYS_PART_START_COLOR, startColor,
                        PSYS_PART_END_COLOR, endColor,
                        PSYS_PART_START_SCALE,startSize,
                        PSYS_PART_END_SCALE,endSize, 
                        PSYS_SRC_PATTERN, pattern,
                        PSYS_SRC_BURST_RATE,rate,
                        PSYS_SRC_ACCEL, push,
                        PSYS_SRC_BURST_PART_COUNT,count,
                        PSYS_SRC_BURST_RADIUS,radius,
                        PSYS_SRC_BURST_SPEED_MIN,minSpeed,
                        PSYS_SRC_BURST_SPEED_MAX,maxSpeed,
                        PSYS_SRC_ANGLE_BEGIN,innerAngle, 
                        PSYS_SRC_ANGLE_END,outerAngle,
                        PSYS_SRC_OMEGA, omega,
                        PSYS_SRC_MAX_AGE, life,
                        PSYS_SRC_TEXTURE, "",
                        PSYS_PART_START_ALPHA, startAlpha,
                        PSYS_PART_END_ALPHA, endAlpha
                        ]);
    llSetColor(endColor,ALL_SIDES);                    
}


vector sColor = <.8,.8,.8>;    // Start color of particles <R,G,B>
vector eColor = <.7,0.7,0.7>;      // End color of particles <R,G,B> (if interpColor == TRUE)





default
{
    state_entry()
{           
        llMessageLinked(LINK_SET,1,"","");        // 1 = white
        llSensorRepeat("","",AGENT,distance,PI,sensetimer);
    }

    sensor(integer total_number)
    {
        
        if( counter++ == timeout)
        {
           // DEBUG("Zap!");
            // zap them
            llMessageLinked(LINK_SET,3,"",llDetectedKey(0));
            counter = 0;
        }
        
        if (white) {
           // DEBUG("Black");
            white = FALSE;
            
            llPlaySound("thunder",1.0);
            llMessageLinked(LINK_SET,2,"","");    // black cloud
            llSetTimerEvent(10);
       }
    }

    no_sensor() {
        counter = 0;
        if (!white)
        {
            //DEBUG("White");
            llMessageLinked(LINK_SET,1,"1","");  // white cloud
            white = TRUE;
        }
    }

    link_message(integer sender_number, integer number, string message, key id)
    {   
        if (number == 1)
        {
            FOGParticles(sColor,eColor);
            
        } else if (number == 2)
{
            FOGParticles(<.1,.1,.1>,<.3,.3,.3>);
        }
    }
}