// Touch the object to light it up.
// Lighting is configurable.
 
integer light_s    = TRUE;
vector  lightcolor = <1.0, 0.75, 0.5>;
float   intensity  = 1.0;             // 0.0 <= intensity <= 1.0
float   radius     = 10.0;            // 0.1 <= radius <= 20.0
float   falloff    = 0.01;            // 0.01 <= falloff <= 2.0
float   glow       = 0.05;
 
toggle()
{
 
    llSetPrimitiveParams([
        PRIM_POINT_LIGHT, TRUE, lightcolor, intensity, radius, falloff,
        PRIM_FULLBRIGHT, ALL_SIDES, light_s,
        PRIM_GLOW,       ALL_SIDES, 0.05
    ]);
      llSetColor(lightcolor, ALL_SIDES);
}
 
default
{
    state_entry()
    {
        llSetText("", <1.0, 1.0, 1.0>, 1.0);
        toggle();
    }
 
   
}