// :CATEGORY:Music
// :NAME:42_minute_Music_Box
// :AUTHOR:Ferd Frederix
// :CREATED:2014-01-07 22:38:00
// :ID:5
// :NUM:1561
// :REV:1.2
// :WORLD:Second Life
// :DESCRIPTION:
// Music player slave script.   Add sound clips just like the 42 minute prim has.
// put these about every 20-25 meters to spread shound through an entire region.
// Add a channel number unique to the music in this prim to the description.

// Rev 1.2: added changed event and the channel comes from the description.

// :CODE:
 
 
integer preloadchannel ;
integer playchannel ;
float text = 0.0;  // set too to see debug title text

default
{
   
    state_entry()
    {
        preloadchannel = (integer) llGetObjectDesc();
        playchannel = preloadchannel + 1;
        llListen(preloadchannel,"","","");
        llListen(playchannel,"","","");
        llSetText("", <0,1,0>, 1.0);
    }
    
    listen(integer channel, string name, key id, string music)
    {
        if (channel == playchannel)
        {
            llSetText(music + "\n playing", <0,1,0>, text);
            llPlaySound(music,1.0);
            
        }   
        else
        {
            llSetText(music + "\npreloaded", <0,1,0>, text);
            llPreloadSound(music);
        }
  
    } 
    
    changed(integer what)
    {
        if (what & CHANGED_INVENTORY)
            llResetScript();
    }

    on_rez(integer param)
    {
        llResetScript();
    }
}

