integer OwnerOnly = FALSE;

key agent;
integer debug = FALSE;         // set to TRUE or FALSE for debug chat on various actions

vector Sitpos = <0.2,0,-1.3>;
vector Sitrot = <0,0,0>;


DEBUG(string str)
{
    if (debug)
        llOwnerSay( str);                    // Send the owner debug info so you can chase NPCS
}


default
{
    state_entry()
    {
        llSay(0, "Hello, sit on me!");
        llSetAlpha(1.0,ALL_SIDES);
        
        rotation Sitrot2 = llEuler2Rot(DEG_TO_RAD * Sitrot);
        llSitTarget(Sitpos, Sitrot2);
    }
 
    on_rez(integer o)
    {
        llResetScript();
    }
    
    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            agent = llAvatarOnSitTarget();
            if (agent != NULL_KEY)
            {                
                if( (agent != llGetOwner())  && OwnerOnly)
                {
                    llUnSit(agent);
                    llSay(0,"Sorry, you cannot ride the tiger. Get your own tiger at http://www.outworldz.com:9000:Virunga");
                    DEBUG("Non-owner Seated");
                }
                else
                {
                    DEBUG("Avatar Seated");
                    llMessageLinked(LINK_SET,0,"Seated",agent);
                    llSetAlpha(0.0,ALL_SIDES);
                }
            }
            else
            {
                llSetAlpha(1.0,ALL_SIDES);
                llMessageLinked(LINK_SET,0,"Unseated","");
            }
        }
    }
    
} 