//XEngine;lsl

// original script by Tiffany Sicling @ OSGrid / Hypergrid Project team
// Revised extensively by WhiteStar Magic @ HyperGrid-Supply-Centre OSGrid 
// =======================================================================
// The SHENGATE sysem is a single Point to Point mechanism and therefore much simpler than any other mechanism
// it uses osTeleportAgent to accomplish this TP process
// this must be enabled in your OpenSim.ini file
//
//
// =======================================================================
// MODFIFY following Fields
string HoverTitle = ""; // for Hovertext over Portal
//n/357/253/611
integer DEFAULTstate = TRUE;            // TRUE = ON & Ready at Startup. FALSE = OFF @ Startup
//
vector LandingPoint = <192, 185,33>;     // Where you want the Avatar to arrive a
vector LookAt       = <0.0,0.0,-1.0>;           // which way you want them facing. Avoid True North at ALL times (BUG THERE IN OS CODE)
// 
string TargetAddress ;                               // In-Grid Teleport (Region Name as defined in region.xml OR region.ini)
//string TargetAddress = "9996,9974";                                      // In-Grid Teleport (Grid Map Locations XXXX,YYYYY)
//string TargetAddress = "first-star.dyndns.org:9000:FirstStar_Station";    //HyperGrid Example (using DNSname:Port:RegionName)
//string TargetAddress = "IPaddress:Port:RegionName";                       // Hypergrid TP are also valid (IPaddress:Port:RegionName)


// ----------------------------------
// variable pour la communicaiton entre l'iris et la porte
// canal sur lequel l'iris et la porte vont communiquer... si plusieurs portes changer le canal.
// l'iris et la porte doivent avoir le meme canal
integer     channel = -125478;  

 

//
// =======================================================================
//
// DO NOT MODIFY BELOW Unless you KNOW LSL Scripting
// =================================================
// Global variables
//list visitor_list;
float range = 1.5; // in meters
float rate = 1.0; // in seconds
string EventHorizonLoopSound = "Event Horizon Loop";                        // Sound looped while the event horizon exists
//
list LastFewAgents;
//
PerformTeleport( key AgentToTP )
{
    integer CurrentTime = llGetUnixTime();
    integer AgentIndex = llListFindList( LastFewAgents, [ AgentToTP ] );           // Is the agent we're teleporting already in the list?
    if (AgentIndex != -1)                                                          // If yes, check to make sure it's been > 5 seconds
    {
        integer PreviousTime = llList2Integer( LastFewAgents, AgentIndex+1 );      // Get the last time they were teleported
        if (PreviousTime >= (CurrentTime - 5)) return;                             // Less than five seconds ago? Exit without teleporting
        LastFewAgents = llDeleteSubList( LastFewAgents, AgentIndex, AgentIndex+1); // Delete the agent from the list
    }
    LastFewAgents += [ AgentToTP, CurrentTime ];                                   // Add the agent and current time to the list
    osTeleportAgent( AgentToTP, TargetAddress, LandingPoint, LookAt );             // Teleport agent to their target
    llSleep(1.0);
    llResetScript();
}
// 
RESET_VOL_DET()
{
    // THIS IS A PATCH.  Resets the Volume Detection as it is borked in OS
    llVolumeDetect( 0); // turn off volume detection
    llVolumeDetect( 1 ); // turn it back on again
}
// PARTICLE EMMISSIONS EFFECTS
PARTICLES()
{
    llParticleSystem(  [
    PSYS_SRC_TEXTURE, llGetInventoryName(INVENTORY_TEXTURE, 0),
    PSYS_PART_START_SCALE, < 0.6, 0.6, 0 >,
    PSYS_PART_END_SCALE, < 0.2, 0.2, 0 >,
    PSYS_PART_START_COLOR, <0.0,0.0,0.0>,
    PSYS_PART_END_COLOR, <1,1,1>,
    PSYS_PART_START_ALPHA, 0.4,
    PSYS_PART_END_ALPHA, 0.0,

    PSYS_SRC_BURST_PART_COUNT, 2,
    PSYS_SRC_BURST_RATE,  0.01,
    PSYS_PART_MAX_AGE, 1.3,
    PSYS_SRC_MAX_AGE, 0.0,
    
    PSYS_SRC_PATTERN, 4,    // 1=DROP, 2=EXPLODE, 4=ANGLE, 8=ANGLE_CONE,
    PSYS_SRC_ACCEL, <0.0,0.0,0.0>,

    PSYS_SRC_BURST_RADIUS, 1.4,
    PSYS_SRC_BURST_SPEED_MIN, 0,
    PSYS_SRC_BURST_SPEED_MAX, 0.00,

    PSYS_SRC_ANGLE_BEGIN,  0.0,
    PSYS_SRC_ANGLE_END, 180*DEG_TO_RAD,
    PSYS_SRC_OMEGA, <0,0,0>,

    PSYS_SRC_TARGET_KEY,  llGetKey(),    //llGetLinkKey(llGetLinkNum() + 1),

    PSYS_PART_FLAGS, ( 0
    | PSYS_PART_INTERP_COLOR_MASK
    | PSYS_PART_INTERP_SCALE_MASK
    | PSYS_PART_EMISSIVE_MASK
    | PSYS_PART_FOLLOW_VELOCITY_MASK
    // | PSYS_PART_WIND_MASK
    // | PSYS_PART_BOUNCE_MASK
    // | PSYS_PART_FOLLOW_SRC_MASK
    | PSYS_PART_TARGET_POS_MASK
    // | PSYS_PART_TARGET_LINEAR_MASK
    ) ] );
} 
  
default
{
    on_rez(integer int)
    {
        llResetScript(); 
    }
    state_entry()
    {
        
        TargetAddress = llGetRegionName();
        // run this code when entering the default state
        //llSetTexture( "40e1fdf5-b4c2-49f4-9512-afcd22576acb", ALL_SIDES);
        llParticleSystem([]);
        llStopSound();    // Turn off the loop sound
        llSetText("",<1,0,0>,1);
        RESET_VOL_DET();
        //  DEFAULTS based on DEFAULTstate, TRUE = ON, FALSE = OFF on Startup
    }
    
    collision_start(integer total_number)  // total_number is the number of avatars detected.
    {
        llWhisper(0, "Teleporting!");
        PerformTeleport( llDetectedKey( 0 ));
    }
    //
    changed(integer change) // something changed, take action
    {
        if(change & CHANGED_OWNER)
        {
            llOwnerSay("Owner Changed, Resetting Script");
            llResetScript();
        } 
        else if (change & (CHANGED_REGION_RESTART|CHANGED_REGION_START)) // that bit is set during a
        {
            llResetScript();
        }
    }
}