// RAKis - Lasst modify SL 02.26.2004
// Rakis.Heron @ www.rakisworld.ch
//-------------------------------------------------------------------------------------
//                             Visitor Board
//-------------------------------------------------------------------------------------
// V4.0   Autosave / Autorestore visitors
// V3.2   Fix accepting invalid time zones
// V5.0   Make osNotecard optional, Config in Description


// Whether to use osNotecard
integer AutoSave = FALSE;

// Controller / Display communication
//
// MessageLinked(LINK_SET, 1 or 2, "ALPHA", "0" or "1")  - alpha setting
// MessageLinked(LINK_SET, 1 or 2, "DRAW", command list to be drawn);
// MessageLinked(LINK_SET, 0, "SWAP", NULL_KEY);    - reverse alpha settings

// Menu Channel
integer menu_chan;

// Waiting for responses
integer Config = FALSE;
integer Exclude_click = FALSE;
integer Timezone_entry = FALSE; 
integer Offset_entry = FALSE;
integer saving = FALSE; 
integer restoring = FALSE;

// Track Parcel only
integer track_parcel = FALSE;

// Timezone
integer offset = 0;     // GMT default
string zone = "GMT";
integer ampm = FALSE;

//Avatars not to be logged
list lExclude = [];

// Draw Parameters
integer row;
integer col;
string Cmd;

// Font Size 12 on a 512 x 1024 pxl board 
integer pxwd = 10; //width
integer pxhi = 18; // height

// Board Entries
list lBdDates = [];
list lBdAgents = [];
list lBdNames = [];

// List of agents
list lCurAgents = [];        // Agents here NOW
list lPreAgents = [];        // Agents here last time
list lNewAgents = [];        // Agents just arrived

// Which display is currently receiving data and is not visible
integer active_display = 1;

//Length of time to wait for dynamic draw to complete
float draw_time = 10.0;

// Notecard Information
key NC_ID;
integer NC_Line;

//--------------------------------------------------
// Initialize Drawing surface
init_draw()
{
    Cmd = "";
    Cmd += "FontName Courier;";
    Cmd += "PenColor black;";
    Cmd += "FontSize 10;";
    Cmd += "FontProp B;";
    Cmd += "PenSize 2;";
}

//--------------------------------------------------
// Generate Text
text_col_row(integer col, integer row, string data)
{
    Cmd += "MoveTo " + (string)(col * pxwd) + "," + (string)(row * pxhi) + ";";
    Cmd += "Text " + data + ";";
}

//--------------------------------------------------
// Draw the board
draw_board()
{
    // Init draw parameters
    init_draw();

    integer i;
    integer j;

    // Eliminate excluded agents
    for (i = 0; i < llGetListLength(lExclude); i++)
    {
        for (j = 0; j < llGetListLength(lBdAgents); j++)
        {
            if (llList2String(lBdAgents, j) == llList2String(lExclude, i))
            {
                lBdAgents = llDeleteSubList(lBdAgents, j, j);
                lBdNames = llDeleteSubList(lBdNames, j, j);
                lBdDates = llDeleteSubList(lBdDates, j, j);
            }
        }
    }
    // Draw the dates and names
    for (i = 0; i < llGetListLength(lBdAgents); i++)
    {
        // Date
        string s = (llList2String(lBdDates, i));
        s = llGetSubString(s, 0, 9) + "T" + llGetSubString(s, 11, 15);
        s = local_time(s, offset, ampm) + " " + zone;
        text_col_row(4, i + 1, s);
        
        // Name
        string s1 = llList2String(lBdNames, i);
        if (llStringLength(s1) > (96 - llStringLength(s)))
        {
            s1 = llGetSubString(s1, 0, 96 - llStringLength(s));
        }   
        text_col_row(llStringLength(s) + 6, i + 1, s1);
    }
    
    // Send drawing to active display
    llMessageLinked(LINK_SET, active_display, "DRAW", Cmd);
    
    // Wait for dynamic texture to resolve
    llSleep(draw_time);
    
    // Switch display's alpha settings and active setting
    llMessageLinked(LINK_SET, 0, "SWAP", NULL_KEY);
    active_display++;
    if (active_display > 2)
    {
        active_display = 1;
    }
}
    
//--------------------------------------------------
// Calculate local time / date 
string local_time(string timestamp, integer shift, integer type)
{
    integer SEC_IN_MIN = 60;
    integer SEC_IN_HOUR = 3600;
    integer SEC_IN_DAY = 86400;

    list days_in_month = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];

    integer year;
    integer month;
    integer day;
    integer hour;
    integer min;
    integer sec;
    integer total_sec;

    // Parse timestamp
    list l = llParseString2List(timestamp, ["-", "T", ":", "."], []);
    year = llList2Integer(l, 0);
    month = llList2Integer(l, 1);
    day = llList2Integer(l, 2);
    hour = llList2Integer(l, 3);
    min = llList2Integer(l, 4);
    sec = llList2Integer(l, 5);

    total_sec = sec + min * SEC_IN_MIN + hour * SEC_IN_HOUR;
    
    // Handle leap years
    if ((year % 4) == 0)
    {
        days_in_month = llListReplaceList(days_in_month, [29], 1, 1);
    }
    
    // Adjust day  
    integer test = shift * SEC_IN_HOUR + total_sec;
    if (test >= SEC_IN_DAY)
    {
        // Adjust to next day
        day++;
        if (day > llList2Integer(days_in_month, month - 1))
        {
            day = 1;
            month++;
            if (month > 12)
            {
                month = 1;
                year++;
            }
        }
        test -= SEC_IN_DAY;
    }
    else if (test < 0)
    {
        //Adjust to previous day
        day--;
        if (day < 1)
        {
            month--;
            if (month < 1)
            {
                month = 12;
                year--;
            }
            day = llList2Integer(days_in_month, month - 1);
        }
        test += SEC_IN_DAY;
    }
    
    // Adjust hour / min / sec
    hour = test / SEC_IN_HOUR;
    test -= hour * SEC_IN_HOUR;
    min = test / SEC_IN_MIN;
    sec = test - min * SEC_IN_MIN;

    // Handle 24 hour or 12 hour clock
    string s;
    string ampm_string = "";
    if (type)
    {
        // Assemple AM/PM time
        if ( hour > 12)
        {
            hour -= 12;
            ampm_string = "PM";
        }
        else
        {
            if (hour == 0)
            {
                hour = 12;
            }
            ampm_string = "AM";
        }
    }
                
    // Assemble response
    s = (string)year + "-" + llGetSubString("0" + (string)month, -2, -1) + "-" +
        llGetSubString("0" + (string)day, -2, -1) + "  " +
        (string)hour + ":" + llGetSubString("0" + (string)min, -2, -1) + " " + ampm_string;
        
    return(s);
}

//-------------------------------------------------
// Save Config Information in Object Description field
save_config()
{
    // Create Config information
    string s = zone + "|";
    s += (string)offset + "|";
    if (ampm)
    {
        s += "12|";
    }
    else
    {
        s += "24|";
    } 
    if (track_parcel)
    {
        s += "PARCEL";
    }
    else
    {
        s += "REGION";
    }
    llSetObjectDesc(s);
}
    
//-------------------------------------------------
// Save Exclude Notecard information
save_exclusions()
{
    list l;
    string s;
    integer list_length;
    integer group5;

    // if osNotecards allowed
    if (AutoSave)
    {
        // Remove any existing "Exclude" notecard
        integer type = llGetInventoryType("Exclude");
        if (type == INVENTORY_NOTECARD)
        {
            llRemoveInventory("Exclude");
        }
    
        // Create Exclusion Notecard
        if (llGetListLength(lExclude) > 0)
        {
            osMakeNotecard("Exclude", lExclude);
        }
        llOwnerSay("Exclusions have been auto-saved");
        saving = FALSE;
    }
    else
    {
        l = lExclude;
        list_length = llGetListLength(l);
        
        if (list_length > 0)
        {
            do
            {
                group5 = 0;    
                s = "\n";
                do
                {
                    s += llList2String(l, 0) + "\n";
                    l = llDeleteSubList(l, 0, 0);
                } while ((++group5 < 5) && (--list_length > 0));
                llOwnerSay(s);
            } while (list_length > 0);
            llOwnerSay("Paste the preceeding " + (string)llGetListLength(lExclude) +
                " line(s) into the Exclude notecard");
        } 
        else
        {
            llOwnerSay("No exclusions defined. No Exclude information created");
        }
        saving = FALSE;
    }
}
    
//-------------------------------------------------
// Save Visitor Notecard information
save_visitors()
{
    list l;
    list l1;
    list l2;
    string s;
    integer i;
    integer list_length;
    integer group5;

    // If osNotecard allowed
    if (AutoSave)
    {    
        // Remove any existing Visitor notecards
        integer type = llGetInventoryType("Visitors");
        if (type == INVENTORY_NOTECARD)
        {
            llRemoveInventory("Visitors");
        }
    
        // Create Visitor notecard
        if (llGetListLength(lBdAgents) > 0)
        {
            l = [];
            for (i = 0; i < llGetListLength(lBdAgents); i++)
            {
                l += (llList2String(lBdAgents, i) + "|" +
                        llList2String(lBdNames, i) + "|" +
                        llList2String(lBdDates, i));
            }
            osMakeNotecard("Visitors", l);
        }
        llOwnerSay("Visitors have been auto-saved");
        saving = FALSE;
        
    }
    else
    {
        l = lBdAgents;
        l1 = lBdNames;
        l2 = lBdDates;
        list_length = llGetListLength(l);
        
        if (list_length > 0)
        {
            do
            {
                group5 = 0;    
                s = "\n";
                do
                {
                    s += (llList2String(l, 0) + "|" +
                        llList2String(l1, 0) + "|" +
                        llList2String(l2, 0) + "\n");         
                    l = llDeleteSubList(l, 0, 0);
                    l1 = llDeleteSubList(l1, 0, 0);
                    l2 = llDeleteSubList(l2, 0, 0);
                } while ((++group5 < 5) && (--list_length > 0));
                llOwnerSay(s);
            } while (list_length > 0);
            
            llOwnerSay("Paste the preceeding " + (string)llGetListLength(lBdAgents) +
             " line(s) into the Visitors notecard");
        } 
        else
        {
            llOwnerSay("No visitors defined. No Visitors information created");
        }
        saving = FALSE;
    }

}
    

//--------------------------------------------------
//------ Initialization State
//--------------------------------------------------
default
{
    // Initialization
    state_entry()
    {
        // Pause to ensure displays are ready
        llSleep(5.0);
        
        // Get Configuration data
        list l = llParseString2List(llGetObjectDesc(), ["|"], []);
        if (llGetListLength(l) == 4)
        {
            zone = llList2String(l, 0);
            offset = llList2Integer(l, 1);
            if (llList2String(l, 2) == "12")
            {
                ampm = TRUE;
            }
            else
            {
                ampm = FALSE;
            }
            if (llList2String(l, 3) == "PARCEL")
            {
                track_parcel = TRUE;
            }
            else
            {
                track_parcel = FALSE;
            }
        }
        
        // Get Exclusion notecard
        state exclusion;
    }
}

//--------------------------------------------------
//------ Get Exclusion notecard State
//--------------------------------------------------
state exclusion
{
    state_entry()
    {
        // Check if there is an Exclusion notecard
        integer type = llGetInventoryType("Exclude");
        if (type == INVENTORY_NOTECARD)
        {
            // Read first line
            NC_Line = 0;
            NC_ID = llGetNotecardLine("Exclude", NC_Line);
        }
        else
        {
            // Get Visitor notecards
            state visitors;
        }
    }
    
    dataserver(key ID, string data)
    {
        if (ID == NC_ID)
        {
            if (data != EOF)
            {
                if (llStringLength(data) > 4)
                {
                    lExclude += data;
                }
            }
            else
            {
                // Get visitor notecards
                state visitors;
            }
        }
        
        // Get next line
        NC_Line++;
        NC_ID = llGetNotecardLine("Exclude", NC_Line);
    }
}

//--------------------------------------------------
//------ Get Visitors notecard State 
//--------------------------------------------------
state visitors
{
    state_entry()
    {
        // Check if there is are Visitor notecards
        integer type = llGetInventoryType("Visitors");
        if (type == INVENTORY_NOTECARD)
        {
            // Read first line
            NC_Line = 0;
            NC_ID = llGetNotecardLine("Visitors", NC_Line);
        }
        else
        {
            // Go to main state
            state main;
        }
    }

    dataserver(key ID, string data)
    {
        if (ID == NC_ID)
        {
            if (data != EOF)
            {
                if (llStringLength(data) > 3)
                {
                    list l = llParseString2List(data, ["|"], []);
                    
                    // Ignore bad lines
                    if (llGetListLength(l) == 3)
                    {
                        lBdAgents += llList2String(l, 0);
                        lBdNames += llList2String(l, 1);
                        lBdDates += llList2String(l, 2);
                    }
                }
            }
            else
            {
                // Go to main state
                state main;
            }
        }
        
        // Get next line
        NC_Line++;
        NC_ID = llGetNotecardLine("Visitors", NC_Line);
    }
}
        
//--------------------------------------------------
//------ Main State 
//--------------------------------------------------
state main
{
    state_entry()
    {
        integer i;
        
        // Initialize displays
        active_display = 1;                               // Display 1 receives commands
        llMessageLinked(LINK_SET, 1, "ALPHA", "0.0");     // Display 1 invisible
        llMessageLinked(LINK_SET, 2, "ALPHA", "1.0");     // Display 2 visible
                
        // Generate a random menu comm channel
        menu_chan = 100 + (integer)(llFrand(9999 - 100 + 1)); 
        
        // Draw initial board
        draw_board();        
                
        // Set Update Timer
        llSetTimerEvent(10.0);       // 10 sec sweep
    }
    
    // Owner commands mode
    touch_start(integer num)
    {
        if (llDetectedKey(0) == llGetOwner())
        {
            // Listen for owner commands
            llListen(0, "", llGetOwner(), "");
            llListen(menu_chan, "", llGetOwner(), "");
            
            // Start coniguration
            Config = TRUE;
            llSetTimerEvent(60.0);
            
            // Send top level menu
            if (AutoSave)
            {
                llDialog(llGetOwner(), "Please make a selection:",
                    ["Timezone", "Offset", "12 Hr", "24 Hr", "Region", "Parcel", "Exclude",
                    "ManSave", "Reset"], menu_chan);
            }
            else
            {
                llDialog(llGetOwner(), "Please make a selection:",
                    ["Timezone", "Offset", "12 Hr", "24 Hr", "Region", "Parcel", "Exclude",
                    "AutoSave", "Save", "Reset"], menu_chan);
            }
        }
        // If waiting for a exclude click
        else if (Exclude_click)
        {
            // Add avatar to ignore list
            lExclude += llDetectedKey(0);
            llSay(0, llKey2Name(llDetectedKey(0)) + " will not be tracked");
            Config = FALSE;
            Exclude_click = FALSE;
            
            // Save Exclusions
            if (AutoSave)
            {
                save_exclusions();
            }
            
            // Redraw board
            draw_board();

            llSetTimerEvent(10.0);
            
            
        }
    }
    
    // Owner Commands
    listen(integer chan, string name, key ID, string data)
    {
        // Menu Responses
        if (chan == menu_chan)
        {
            if ((data == "Exclude") || (data == "Timezone") || (data == "Offset") ||
                (data == "Save"))
            {
                if (data == "Timezone")
                {
                    llOwnerSay("Enter Timezone Identifier (e.g. EST)");
                    Timezone_entry = TRUE;
                }
                else if (data == "Offset")
                {
                    llOwnerSay("Enter offset hours from GMT to your timezone (e.g. -5)");
                    Offset_entry = TRUE;
                }
                else if (data == "Save")
                {
                    llDialog(llGetOwner(), "Please select what to save:",
                        ["Exclusions", "Visitors"], menu_chan);
                }
                else
                {
                    llSay(0, "Avatar to be excluded from board must now click the board");
                    Exclude_click = TRUE;
                }
            }
            else
            {
                if (data == "12 Hr")
                {
                    llOwnerSay("Board set for 12 hour clock with AM/PM");
                    ampm = TRUE;
                }
                else if (data == "24 Hr")
                {
                    llOwnerSay("Board set for 24 hour clock");
                    ampm = FALSE;
                }
                else if (data == "Region")
                {
                    llOwnerSay("Board will monitor the entire region");
                    track_parcel = FALSE;
                }
                else if (data == "Parcel")
                {
                    llOwnerSay("Board will monitor the parcel it is on");
                    track_parcel = TRUE;
                }
                else if (data == "Reset")
                {
                    llOwnerSay("Board is being reset to intial values");
                    llResetScript();
                }
                else if (data == "AutoSave")
                {
                    AutoSave = TRUE;
                    llOwnerSay("AutoSave is enabled, requiring OSSL notecard support");
                }
                else if (data == "ManSave")
                {
                    AutoSave = FALSE;
                    llOwnerSay("AutoSave is disabled. Use copy/paste to create notecards");
                }
                else if (data == "Exclusions")
                {
                    save_exclusions();
                }
                else if (data == "Visitors")
                {
                    save_visitors();
                }
                
                // Quit Config
                Config = FALSE;
                save_config();
                draw_board();
                llSetTimerEvent(10.0);
            }
        }   
        
        // Owner Entries
        else if (chan == 0)
        {            
            // Timezone
            if (Timezone_entry)
            {
                Timezone_entry = FALSE;
                
                // Validate
                if (llStringLength(data) > 5)
                {
                    llOwnerSay("Invalid Timezone");
                }
                else
                {
                    zone = data;
                    llOwnerSay("Timezone set to " + zone);
                }
            }
            
            // Offset
            else if (Offset_entry)
            {
                Offset_entry = FALSE;
                integer i = (integer)data;
                if ((i < -12) || (i > 12))
                {
                    llOwnerSay("Invalid Offset");
                }
                else
                {
                    offset = i;
                    llOwnerSay("Timezone offset set to " + (string)offset);
                }
            }
            Config = FALSE;
            save_config();
            draw_board();
            llSetTimerEvent(10.0);
        }
    }
    
    // Look for avatars
    timer()
    {
        integer i;
        integer j;
        
        // Stop Owner commands
        if (Config)
        {
            Config = FALSE;
            llOwnerSay("Configuration mode ended");
        }
        
        // Identify all agents in parcel or region NOW
        if (track_parcel)
        {
            lCurAgents = llGetAgentList(AGENT_LIST_PARCEL, []);
        }
        else
        {    
            lCurAgents = llGetAgentList(AGENT_LIST_REGION, []);
        }
        
        // Eliminate owner
        for (i = 0; i < llGetListLength(lCurAgents); i++)
        {
            if (llGetOwner() == llList2String(lCurAgents, i)) 
            {
                lCurAgents = llDeleteSubList(lCurAgents, i, i);
            }
        }  
        
        // Identify new agents
        lNewAgents = [];
        for (i = 0; i < llGetListLength(lCurAgents); i++)
        {
            integer found = FALSE;
            for (j = 0; j < llGetListLength(lPreAgents); j++)
            {
                if (llList2String(lCurAgents, i) == llList2String(lPreAgents, j))
                {
                    found = TRUE;
                }
            }
            if (!found)
            {
                lNewAgents += llList2String(lCurAgents, i);
            }
        }
        
        // Remember Current Agents
        lPreAgents = lCurAgents;
        
        // Add new agents to board
        for (i = 0; i < llGetListLength(lNewAgents); i++)
        {
            // Delete last entry if board list full
            if (llGetListLength(lBdAgents) >= 30)
            {
                lBdAgents = llDeleteSubList(lBdAgents, -1, -1);
                lBdNames = llDeleteSubList(lBdNames, -1, -1);
                lBdDates = llDeleteSubList(lBdDates, -1, -1);
            }
                
            // Insert new entry at top
            lBdAgents = llListInsertList(lBdAgents, [llList2String(lNewAgents, i)], 0);
            lBdNames = llListInsertList(lBdNames, [llKey2Name(llList2String(lNewAgents, i))], 0);
            string ts = llGetTimestamp();
            lBdDates = llListInsertList(lBdDates, 
                [llGetSubString(ts, 0, 9) + " " + llGetSubString(ts, 11, 15)], 0);
        }
        
        // Redraw the board
        if (llGetListLength(lNewAgents) > 0)
        {
            draw_board();
            
            // Autosave visitors
            if (AutoSave)
            {
                save_visitors();
            }
        }
    }
} 