// Standard pose script, pared down by Cherry Hainsworth.
// It will use the animation you put in the "Sit Target" object, no need to write the name in.
// The Sit Target Setter will output a line of code in chat. Copy it from your Chat history,
// then paste it below.
// If you really must have floating text, fill it in where it says sit_text, below. 
// Otherwise, leave it blank.



string TITLE="";            
string ANIMATION=""; 
string sit_text="";
key avatar;
key trigger;

key dataserver_key = NULL_KEY;


use_defaults()
{
    llSetSitText(sit_text);
        llSetText(TITLE,<1,1,1>,0.7);
}

init()
{

    if(llGetInventoryNumber(INVENTORY_ANIMATION) == 0)      
    {
        llWhisper(0,"Error: No animation found. Cannot pose.");
        ANIMATION = "sit";
    }
    else
        ANIMATION = llGetInventoryName(INVENTORY_ANIMATION,0);
}

default
{
    state_entry()
    {
        // replace this with your copied sit target line.
      llSitTarget(<-0.745704,0.088667,-0.011662>, <0.145666,0.707250,-0.107511,-0.683389>);  
        init();
    }
        
    touch_start(integer detected)
    {
        
    }
    
    changed(integer change)
    {
        if(change & CHANGED_LINK)
        {
            avatar = llAvatarOnSitTarget();
            if(llKey2Name(avatar) != "")
            {
                llRequestPermissions(avatar, PERMISSION_TRIGGER_ANIMATION);
            }
            else
            {
                if (llKey2Name(llGetPermissionsKey()) != "" && trigger == llGetPermissionsKey()) 
                {
                    llStopAnimation(ANIMATION);
                    trigger = NULL_KEY;
                }
            }
        }
    }
    
    run_time_permissions(integer perm)
    {
        avatar = llAvatarOnSitTarget();
        if(perm & PERMISSION_TRIGGER_ANIMATION && llKey2Name(avatar) != "" && avatar == llGetPermissionsKey())
        {
            trigger = avatar;
            llStopAnimation("sit");
            llStartAnimation(ANIMATION);
            llSetText("",<1,1,1>,0);
        }
    }
}  