// in most cases this script shouldn't be in the root of a linkset

//Jeff: Put script in door then link to house, reset script and adjust prim shape first to have it going in the good direction then adjust MoveOnLocalGrid value 

vector MoveOnLocalGrid;
float TimeItTakesForDoorToOpen;

integer Direction;

init()
{
    //MoveOnLocalGrid = <1.0, 0.0, 0.0>;
    MoveOnLocalGrid = <4.5, 0.0, 0.0>; // adjust here
    TimeItTakesForDoorToOpen = 4.0;

    Direction = 1;
}

slide_on_local_grid()
{
    vector PositionBeforeMovement = llGetLocalPos();
    vector VectorForDoorMovement = Direction*MoveOnLocalGrid*llGetLocalRot();


    llResetTime();

    float i;
    do
    {
        i = llGetTime()/TimeItTakesForDoorToOpen;

        llSetLinkPrimitiveParamsFast(LINK_THIS, [
            PRIM_POSITION, PositionBeforeMovement + i*VectorForDoorMovement]);

        // be nice to the servers, 20 FPS should be enough!
        llSleep(0.05);
    }
    while (llGetTime() < TimeItTakesForDoorToOpen && i <= 1.0);

    llSetLinkPrimitiveParamsFast(LINK_THIS, [
        PRIM_POSITION, PositionBeforeMovement + VectorForDoorMovement]);

    // swap directions
    Direction *= -1;
}

default
{
    state_entry()
    {
        init();
    }

    touch_start (integer num_detected)
    {
        slide_on_local_grid();
    }
    
    on_rez (integer start_param)
    {
    llResetScript();
    }
} 