// Copyright 2009 Richie Levenque
// Created for Morphe Inc
// Clocktower Bell Rotation Script
// Unlimited Rights bestowed on Abel Dreamscape to do with this as he wishes

string chimesound = "belltole_1";
float chimevolume = 1.0;
integer rotatesteps=6; // Use 6 for 1/4 of the way up, 8 for half way, 6 suggested for included chimesound

integer time;
integer minutes;


ClockRotate(integer direction){
    //This is the brains of the rotations, DO NOT MODIFY HERE UNLESS YOU KNOW WHAT YOU"RE DOING
    rotation delta;
    rotation rot = llGetRot();
    integer steps=1;
    float desiredRot = PI/16;
    while(steps<rotatesteps){
        desiredRot = PI/16 * direction;
        delta = llEuler2Rot(<desiredRot,0,0>);
        rot = delta * rot;
        llSetRot(rot);
        steps=steps+1;
    }
}

setdefaultrotation(){
    //This forces the bell to work right, in case lag screwed it up
    //   and should work regardless of how the bell is rotated
   rotation axis=llGetRot();
   llSetRot(<0.00000, 0.00000, axis.z, axis.s>);
}

default
{
    state_entry()
    {
        llSetTimerEvent(60.0); // Check every minute
        
    }

    touch_start(integer total_number)
    { 
        // Comment out the 7 lines below, if you do not wish "Touch" to start off the bell
                setdefaultrotation(); // Reset to avoid lag making clock look bad
                llPlaySound(chimesound, chimevolume);//Play Sound
                ClockRotate(1); // Move one direction
                ClockRotate(-1);// Move back to the bottom
                ClockRotate(-1);// Move the Other Direction
                ClockRotate(1); // Move back to the bottom
                llSleep(3.0);   //Give a pause, for the script to finish         
    }

    timer()
        {
        time = (integer)llGetWallclock(); // seconds since midnight
        minutes = (time % 3600) / 60;
        llSetSoundQueueing(TRUE);
        if (minutes == 0)
            { // Do the work, force to start at the bottom, start sounds, and move the clock 4 steps
                setdefaultrotation(); // Reset to avoid lag making clock look bad
                llPlaySound(chimesound, chimevolume);//Play Sound
                ClockRotate(1); // Move one direction
                ClockRotate(-1);// Move back to the bottom
                ClockRotate(-1);// Move the Other Direction
                ClockRotate(1); // Move back to the bottom
                llSleep(3.0);   //Give a pause, for the script to finish         
            }
        }

}
