list auth_list = [];
string open_message = "";   
string close_message = "";                 
string lock_message = "Sorry %nn%, im Moment geschlossen";
float open_time = 5.0;                   
string open_sound = ""; 
string close_sound = "";   
integer door_open = FALSE;
integer locked = FALSE;
integer listen_tag = -1;
float interval = 10.0;


integer channel = 616;
integer menu_handler;
integer listenx= FALSE;
string tmp;


integer DOOR_OPEN=1;
integer DOOR_CLOSE=-1;
 
vector door_open_dir = <1.0, 0.0, 0.0>; 
integer door_move_steps = 3;

// ===============================================
// FUNCTIONS FOR OPENING AND CLOSING DOOR
// ===============================================
door_move(integer open) 
{
    vector curr_pos = llGetPos();
    rotation curr_rot = llGetRot();
    vector curr_sca = llGetScale();
    integer step;
    
    vector curr_dir = open * ( <curr_sca.x * door_open_dir.x,
                                curr_sca.y * door_open_dir.y,
                                curr_sca.z * door_open_dir.z> * curr_rot ) / door_move_steps;
    vector next_pos;
    
    next_pos = curr_pos;
    for (step=0 ; step < door_move_steps ; step++)
    {
        next_pos += curr_dir;
        llSetPos(next_pos);
    }
 
}



authorised(string name) {
    listenx = TRUE;
    llShout(7,name);
       
}

string replace(string main, string old, string new)  // Search and replace 
{                                                   //  function for strings
    string temp = "";
    list m = llParseString2List(main,["%"],[]);
    integer i;   
    for(i = 0; i < llGetListLength(m); i ++){
        string c = llList2String(m,i);
        if (c == old){
            temp += new;
        }else{
            temp += c;
        }
    }
    return temp;
}


float stopListening()                // Kills the listen function
{                                   //  in order to save resources
    if(listen_tag != -1)
        llListenRemove(listen_tag);
    listen_tag = -1;
    return TRUE;
}

integer open(string av_name) // Opens the door.
{
    if (open_sound != "")
        llTriggerSound(open_sound, 0.5);
    if (open_message != "")
        llSay(0, replace(open_message,"nn",av_name));
    // vv  Replace this snippet with custom code to close the door vv 
    door_move(DOOR_OPEN);
    // ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^
    return TRUE;
}
//- - - - - - - - - - - - - - - -     
integer close(string av_name) // Closes the door.
{
    if (close_sound != "")
        llTriggerSound(close_sound, 0.5);
    if (close_message != "")
       llSay(0, replace(close_message,"nn",av_name));
        door_move(DOOR_CLOSE);
    // ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^
    return FALSE;
}
default
{
    state_entry()
    {
        listen_tag = llListen(channel,"","","");
        
        
    }
    
   
        
    timer() {
       stopListening();
        if (door_open){
            door_open = close("the script");
        }
    }

    collision_start(integer total_number)
    {
        llSay(616,"open");
        tmp = llDetectedName(0);
        if (!door_open){
            
            if (locked) {
                  llSay(0,"locked");
                   listen_tag = llListen(channel,"","","");
                   authorised(tmp);
                   
                   llSetTimerEvent(open_time);
            }
            else {
                door_open = open(tmp);
                listen_tag = llListen(channel,"","","");
                llSetTimerEvent(open_time);
            } 
                  
               
        } else {
            door_open = close(tmp);
        }
            
    }
    
     touch_start(integer total_number)
    {
        tmp = llDetectedName(0);
        if (!door_open){
            
            if (locked) {
                  llSay(0,"locked");
                   listen_tag = llListen(channel,"","","");
                   authorised(tmp);
                   
                   llSetTimerEvent(open_time);
            }
            else {
                door_open = open(tmp);
                listen_tag = llListen(channel,"","","");
                llSetTimerEvent(open_time);
            } 
                  
               
        } else {
            door_open = close(tmp);
        }    
                 
                           
    }
    
    
    listen(integer chan, string name, key id, string msg) {
         
         if (msg == "open")
           {
              state  collision_start; 
               
            }
         
         
           if (msg == "lock")
           {
               
                locked = TRUE;
               door_open = close(llDetectedName(0));
            llSay(0,"Door Locked");
            }
            if (msg == "unlock"){
                locked = FALSE;
              llSay(0,"Door Unlocked");
            } 
            
            if (msg == "authorised" && listenx) {
               if(!door_open) { 
                   door_open = open(tmp);
                   listen_tag = llListen(channel,"","","");
                   listenx = FALSE;
                   llSetTimerEvent(open_time);
                }
            } 
         
        
        
    }
}
