    // The most basic of pose scripts

    // change to the name of animation contained within your sittable object
    string pose = "Sitting pose";

    // change to x,y,z offset of object center where you want to appear (never all 0)
    vector target = <0.0, 0.0, -0.2>;

    // optional sit text to appear over object
    string text = "sit";

    default {
        state_entry()
        {
            llSitTarget(target, ZERO_ROTATION);
            llSetSitText(text);
            llSetText(text,<1.0,0.0,0.0>,1.0);
            llSetAlpha(1.0, ALL_SIDES);
        }

        changed(integer change)
        {
            if (change & CHANGED_LINK)
            {
                if (llAvatarOnSitTarget() != NULL_KEY)
                {
                    llRequestPermissions(llAvatarOnSitTarget(), PERMISSION_TRIGGER_ANIMATION);
                    llStopAnimation("1a5fe8ac-a804-8a5d-7cbd-56bd83184568");
                    llStartAnimation(pose);
                    llSetText("",<1.0,0.0,0.0>,1.0);
                    llSetAlpha(0, ALL_SIDES);
                }
                else
                {
                    llStopAnimation(pose);
                    llSetText(text,<1.0,0.0,0.0>,1.0);
                    llSetAlpha(1.0, ALL_SIDES);
                }
            }
        }
    }