// RAKis - Lasst modify SL 02.26.2004
// Rakis Heron @ yeali.outworldz.net:8002
// ------------------------------------------------------------------------------------
//                        Visitor Board Display Script
// ------------------------------------------------------------------------------------

// Controller / Display communication
//
// MessageLinked(LINK_SET, 1 or 2, "ALPHA", "0" or "1")  - alpha setting
// MessageLinked(LINK_SET, 1 or 2, "DRAW", command list to be drawn);
// MessageLinked(LINK_SET, 0, "SWAP", NULL_KEY);    - reverse alpha settings


// Object name as an integer
integer identity;

// Face of board
integer bd_face = 4;
integer visible;

//------------------------------------------------------------------
// Main function
default
{
    state_entry()
    {
        identity = (integer)llGetObjectName();
    }
    
    on_rez(integer num)
    {
        llResetScript();
    }
    
    // Receive instructions from Controller
    link_message(integer sender, integer code, string command, key data)
    {
        // Check if it's for this display
        if (code == identity)
        {
            // Set prim's alpha
            if (command == "ALPHA")
            {
                if (data == "0.0")
                {
                    visible = FALSE;
                    llSetAlpha(0.0, bd_face);
                }
                else
                {
                    visible = TRUE;
                    llSetAlpha(1.0, bd_face);
                }
            }
            
            // Draw on prim
            else if (command == "DRAW")
            {   
                osSetDynamicTextureDataBlendFace("", "vector", data, 
                    "width:1024,height:512,bgcolour:CadetBlue", FALSE, 2, 0, 255, bd_face);
            }
        }
        
        // Check if for both displays
        else if (code == 0)
        {
            if (command == "SWAP")
            {
                if (visible)
                {
                    llSetAlpha(0.0, bd_face);
                }
                else
                {
                    llSetAlpha(1.0, bd_face);
                }
                visible = !visible;
            }
        }
    }
}
 