integer giLighted   = TRUE;
float gfHeight    = 2;


Smoke()
{
    llParticleSystem([
        PSYS_PART_FLAGS, 0 | PSYS_PART_EMISSIVE_MASK | PSYS_PART_INTERP_COLOR_MASK | PSYS_PART_INTERP_SCALE_MASK |
        PSYS_PART_FOLLOW_VELOCITY_MASK | PSYS_PART_WIND_MASK | PSYS_PART_BOUNCE_MASK,
        PSYS_SRC_PATTERN,PSYS_SRC_PATTERN_ANGLE,
        PSYS_PART_START_COLOR, <0.2, 0.2, 0.2>,
        PSYS_PART_END_COLOR, <0.4, 0.4, 0.4>,
        PSYS_PART_START_SCALE, <0.06000, 0.08000, 0.06000> * gfHeight,
        PSYS_PART_END_SCALE, <0.04000, 0.08000, 0.06000> * gfHeight,
        PSYS_SRC_ACCEL, <0.00000, 0.00000, 0.50000>,
        PSYS_PART_MAX_AGE, 2.0000 * gfHeight,
        PSYS_SRC_BURST_RATE, 0.20000,
        PSYS_SRC_BURST_PART_COUNT, 10,
        PSYS_SRC_BURST_RADIUS, 0.00000,
        PSYS_SRC_BURST_SPEED_MIN, 0.100000,
        PSYS_SRC_BURST_SPEED_MAX, 0.500000,
        PSYS_SRC_ANGLE_BEGIN, -0.0*PI,
        PSYS_SRC_ANGLE_END, -1.4*PI,
        PSYS_SRC_OMEGA, <0.00000, 0.00000, 0.00000>,
        PSYS_SRC_MAX_AGE, 0.000000,
        PSYS_PART_START_ALPHA, 1.000000,
        PSYS_PART_END_ALPHA, 0.100000
    ]);
    llSleep(1.5);                                                           
    llParticleSystem([]);                                                   
}
                                            
Flame()
{
     llParticleSystem([
        PSYS_PART_FLAGS, 0 | PSYS_PART_EMISSIVE_MASK | PSYS_PART_INTERP_COLOR_MASK | PSYS_PART_INTERP_SCALE_MASK |
        PSYS_PART_FOLLOW_VELOCITY_MASK | PSYS_PART_WIND_MASK | PSYS_PART_BOUNCE_MASK,
        PSYS_SRC_PATTERN,PSYS_SRC_PATTERN_ANGLE,
        PSYS_PART_START_COLOR, <1.0, 0.5, 0.0>,
        PSYS_PART_END_COLOR, <1.0, 1.0, 0.0>,
        PSYS_PART_START_SCALE, <0.06000, 0.08000, 0.06000> * gfHeight,
        PSYS_PART_END_SCALE, <0.04000, 0.08000, 0.06000> * gfHeight,
        PSYS_SRC_ACCEL, <0.00000, 0.00000, 0.00000>,
        PSYS_PART_MAX_AGE, 0.30000 * gfHeight,
        PSYS_SRC_BURST_RATE, 0.020000,
        PSYS_SRC_BURST_PART_COUNT, 10,
        PSYS_SRC_BURST_RADIUS, 0.00000,
        PSYS_SRC_BURST_SPEED_MIN, 0.100000,
        PSYS_SRC_BURST_SPEED_MAX, 0.500000,
        PSYS_SRC_ANGLE_BEGIN, -0.0*PI,
        PSYS_SRC_ANGLE_END, -1.4*PI,
        PSYS_SRC_OMEGA, <0.00000, 0.00000, 0.00000>,
        PSYS_SRC_MAX_AGE, 0.000000,
        PSYS_PART_START_ALPHA, 1.000000,
        PSYS_PART_END_ALPHA, 0.100000
    ]);
}




default
{
    state_entry()
    {
        Flame();
    }

    on_rez(integer iStartParameter)
    {
        llResetScript();
    }

    touch_start(integer iNumberTouching)
    {
        integer i = 0;
        do {
            if (giLighted)
            {
                Smoke();
                giLighted = FALSE;                                          
            }
            else
            {
                Flame();
                giLighted = TRUE;                                           
            }
            ++i;
        } while (i < iNumberTouching);

    }
}

