// Rakis Heron @ yeali.outworldz.net:8002
//
// === SET DESTINATION INFO HERE ===
string Destination ="yeali.outworldz.net:8002/Free House Market";   // your target destination here (SEE NEXT LINES) Can Be
vector LandingPoint = <518,147,22>;     // the landing point for avatar to arrive at
vector LookAt = <1,1,1>;                // which way they look at when arriving
// === SET USAGE MODES HERE ===
integer TouchTelePort = TRUE;          // set to TRUE if you want TP on Touch
integer CollideTeleport = TRUE;         // set to TRUE if you want to TP on Collision
//                                      // NOTE:  Collisions CAN be tricky in OpenSim
// ========================================================================================
//                  DO NOT MODIFY BELOW UNLESS YOU ARE CERTAIN
// ========================================================================================
list LastAgents = [];                   // retention list for de-bouncer used for Collisions
                                        // preventing Multiple Triggers from occuring
key agent;
//
PerformTeleport( key AgentToTP )
{
    llWhisper(0, "Teleporting you to : "+Destination);
   
    integer TimeNow = llGetUnixTime();
    integer a_idx = llListFindList( LastAgents, [ AgentToTP ] );
    if (a_idx != -1)
    {
        integer TimeLast = llList2Integer( LastAgents, a_idx + 1 );
        if (TimeLast >= (TimeNow - 6)) return;
        LastAgents = llDeleteSubList( LastAgents, a_idx, a_idx+1);
    }
    LastAgents += [ AgentToTP, TimeNow ];  // agent just TP'd so add to list with NOWTIME
    osTeleportAgent(AgentToTP, Destination, LandingPoint, LookAt);   
}
//============
// MAIN APP
//============ 
default
{
    on_rez(integer start_param)
    {
        llResetScript();
    }
    changed(integer change)     // something changed, take action
    {
        if(change & CHANGED_OWNER)
        {
            llResetScript();
        }
        else if (change & 256)  // that bit is set during a region restart
        {                       
            llResetScript();
        }
    }
   
    state_entry()
    {
        string TOUCH = "OFF";
        string COLLIDE = "OFF";
        if(TouchTelePort) TOUCH = "ON";
        if(CollideTeleport) COLLIDE = "ON";
        llOwnerSay("Teleportal Active: Collision = "+COLLIDE+" / Touch = "+TOUCH);
    }
   
    touch_start(integer num_detected)
    {
        key agent = llDetectedKey(0);
        if(TouchTelePort) PerformTeleport( agent );
    }
   
    // This is TRICKY / FLAKY  Alternates are COMMENTED here. REMOVE the first // and comment out the collision*() you wish to try
    //collision(integer num_detected)         // Triggers IMMEDIATE Response on Contact / Collision. OFTEN Causes Duplicate trigger
    //collision_end(integer num_detected)     // Will WAIT till collisions are COMPLETED,
                                              // means a DELAY till collisions stop so you have to BACK OFF the prim & collisions Stop
                                              //
    collision_start(integer num_detected)   // Immediate Response, CAN cause multiple HITS, INFREQUENTLY (WORKS BEST)
    {
        key agent = llDetectedKey(0);
        if(CollideTeleport) PerformTeleport( agent );
    }
}  