float fPoofTime = 30.0;

// Until the rezzer receives sClearCmd on channel CLEAR_CH,
// or until the rezzer times out; it will allow rezzing again.
string sClearCmd;
integer CLEAR_CH  = -99;

default
{
    on_rez(integer start_param)
    {
        // This needs to be set in vehicles rezzed by rezzers; see discssion here:
        // http://opensimulator.org/mantis/view.php?id=7880
        llSetStatus(STATUS_DIE_AT_EDGE, FALSE);

        // If a parameter was passed by the rezzer, use it as poof time
        if (start_param > 0) {
            fPoofTime = (float)start_param;
        } else {
            fPoofTime = 30.0;
        }
        
        sClearCmd = "CLEAR "+llGetObjectName();
        
        llSay(0, "I will poof in "+(string)llRound(fPoofTime)+" seconds if unused");
        llSetTimerEvent(fPoofTime);    
    }
    
    changed(integer what)
    {
        if (what & CHANGED_LINK) {
            key avi = llAvatarOnSitTarget();
            
            if (avi == NULL_KEY) {
                llDie();
            } else {
                llSetTimerEvent(0);
                llSay(CLEAR_CH, sClearCmd);
            }
        }
    }
    
    timer()
    {
        llSetTimerEvent(0);
        llSay(CLEAR_CH, sClearCmd);
        llDie();
    }
}