//Global variable to keep the ID returned from llListen - it's important to do this
//so the previous owner still isn't listened for as we can clear the listen with this ID
integer listenID;

integer WindowChannel = 111101;  // Change this (and on the controller) to create zones of windows that operate together


//When the windows are open this is how transparent they will be. Lower
//numbers = higher transparency. 0.2 is the lowest you can go.
float transparencyAmount = 0.2;


init()
{
    llListenRemove(listenID);   
    listenID = llListen(WindowChannel,"","","");    
    llSetAlpha(transparencyAmount,0);  
}

default
{
    state_entry()
    {
        init();
    }


    on_rez(integer times)
    {
        llResetScript();
        init();
        llWhisper(0,"Window reset...");    
    }


    listen(integer channel, string name, key id, string message)
    {
        if (message == (string)llGetOwner()+"closed") {
            llSetAlpha(1,ALL_SIDES);
        }
        if (message == (string)llGetOwner()+"open") {
            llSetAlpha(transparencyAmount,0);
        }
    }
    
}
