//  RAKis - Rakis Heron last modify 02.26.2004
//  Copyright (c) 2003-2019 by RAK Internet Service
//
// Touch the object to light it up.
// Lighting is configurable.
// 
integer light_s    = TRUE;
vector  lightcolor = <1.0, 1.0, 1.0>;
float   intensity  = 0.1;             // 0.0 <= intensity <= 1.0
float   radius     = 20.0;            // 0.1 <= radius <= 20.0
float   falloff    = 0.01;            // 0.01 <= falloff <= 2.0
float   glow       = 0.1;
 
toggle()
{
    float thisglow = 0.0;
    light_s = !light_s;
 
    if (light_s)
        thisglow = glow;
 
    llSetPrimitiveParams([
        PRIM_POINT_LIGHT, light_s, lightcolor, intensity, radius, falloff,
        PRIM_FULLBRIGHT, ALL_SIDES, light_s,
        PRIM_GLOW,       ALL_SIDES, thisglow
    ]);
      llSetColor(lightcolor, ALL_SIDES);
}
 
default
{
    state_entry()
    {
        llSetText("", <1.0, 1.0, 1.0>, 1.0);
        toggle();
    }
 
    touch_start(integer total_number)
    {
        toggle();
    }
} 