list    Keys;
float   configRotTime   = 1.0;
integer configRotSteps  = 2;
integer configReverse   = 0;
integer configRotAngle  = 90;
string  configAxis      = "z";
float   configAutoClose = 0.0;
float   configDistance  = 2.0;
integer configCollide   = FALSE;
integer configSensor    = FALSE;
string  configDouble    = "";
string  soundOpen       = "Door open";
string  soundClose      = "Door close";
string  soundLock       = "Lock";
string  soundUnlock     = "Unlock";
string  soundKnock      = "Door knock";

integer accessLoaded    = FALSE;
integer doorLock        = FALSE;
integer doorClosed      = TRUE;
float   touchTime;
float   touchDouble     = FALSE;
integer touchDrag       = FALSE;
key     doubleID        = NULL_KEY;

integer settingsLine    = 0;
key     settingsKey     = NULL_KEY;
integer settingsSection = 0;            // 1=settings, 2=keys


sound(string name)
{
    if (llGetInventoryType(name) == INVENTORY_SOUND) {
        llPlaySound(name, 1.0);
    }
    else if (osIsUUID(name)) {
        llPlaySound(name, 1.0);
    }
}

door() {
    integer     i;
    rotation    delta;
    rotation    rot         = llGetLocalRot();
    float       direction   = configRotAngle;
    
    if (doorClosed) {
        sound(soundOpen);
        doorClosed  = FALSE;
        direction = configRotAngle;

        llCollisionFilter("", NULL_KEY, FALSE);
        doorMsg(doorClosed, "door");
        if (configAxis == "x")      delta = llEuler2Rot(<direction/configRotSteps, 0, 0> * DEG_TO_RAD);
        else if (configAxis == "y") delta = llEuler2Rot(<0, direction/configRotSteps, 0> * DEG_TO_RAD);
        else if (configAxis == "z") delta = llEuler2Rot(<0, 0, direction/configRotSteps> * DEG_TO_RAD);
    } else {
        doorClosed  = TRUE;
        direction = -configRotAngle;
        
        llSetTimerEvent(0.0);
        llSensorRemove();
        llCollisionFilter("", NULL_KEY, TRUE);
        doorMsg(doorClosed, "door");
        if (configAxis == "x")      delta = llEuler2Rot(<direction / configRotSteps, 0, 0> * DEG_TO_RAD);
        else if (configAxis == "y") delta = llEuler2Rot(<0, direction / configRotSteps, 0> * DEG_TO_RAD);
        else if (configAxis == "z") delta = llEuler2Rot(<0, 0, direction / configRotSteps> * DEG_TO_RAD);
    }
    for (i =0; i < configRotSteps; i++) {
        rot = delta * rot;
        llSetLinkPrimitiveParamsFast(LINK_THIS, [PRIM_ROT_LOCAL, rot]);
        llSleep(configRotTime / configRotSteps);
    }
    if (doorClosed) {
        sound(soundClose);
    }
    else if (configAutoClose > 0.0) {
        llSetTimerEvent(configAutoClose);
    }
}

door(key id, float distance)
{
    door();
    if (configSensor) {
        llSensorRepeat("", id, AGENT, distance + 0.5, TWO_PI, 1.0);
        llSetTimerEvent(0.0);
    }
}

addKey(string data, integer send)
{
    if (llStringLength(data) > 0) {
        string name = data;
        name = llStringTrim(name, STRING_TRIM_HEAD);
        name = llStringTrim(name, STRING_TRIM_TAIL);
        
        if (llGetSubString(name, 0, 0) == "#") return;
        Keys = Keys + name;
        if (send) llMessageLinked(LINK_ALL_OTHERS, 1, name, "addkey");
    }
}

string trimString(string data)
{
    if (llStringLength(data) > 0) {
        data = llStringTrim(data, STRING_TRIM_HEAD);
        data = llStringTrim(data, STRING_TRIM_TAIL);
        
        if (llGetSubString(data, 0, 0) == "#")  return "";
        else                                    return data;
    }
    return "";
}

doorMsg(integer status, string part)
{
    if (llStringLength(configDouble) > 0) {
        llMessageLinked(LINK_ALL_OTHERS, status, configDouble, part);
    }
}

lock(integer lock, string name) {
    if (doorLock != lock) {
        if (!doorLock) {
            doorLock = TRUE;
            doorMsg(doorLock, "lock");
            llSay(0, "/me locked.");
            sound(soundLock);
        } else {
            doorLock = FALSE;
            doorMsg(doorLock, "lock");
            llSay(0, "/me unlocked.");
            sound(soundUnlock);
        }
    }
}

loadSettings()
{
    settingsLine    = 0;
    settingsSection = 0;
    settingsKey     = NULL_KEY;
    
    if (loadSettings(1)) {
        return;
    } else {
        loadSettings(2);
    }
    
    //if (llGetInventoryType("Settings") == INVENTORY_NOTECARD)
    //{
    //    settingsSection = 1;
    //    settingsKey = llGetNotecardLine("Settings");
    //}
    //else if (llGetInventoryType("Access List") == INVENTORY_NOTECARD) {
    //    settingsSection = 2;
    //    settingsKey = llGetNotecardLine("Access List", settingsLine);
    //}
}

integer loadSettings(integer section)
{
    if (section == 1) {
        if (llGetInventoryType("Settings") == INVENTORY_NOTECARD) {
            settingsLine    = 0;
            settingsSection = 1;
            settingsKey     = llGetNotecardLine("Settings", settingsLine);
            
            return TRUE;
        } else {
            return FALSE;
        }
    }
    else if (section == 2) {
        if (llGetInventoryType("Access List") == INVENTORY_NOTECARD) {
            settingsLine    = 0;
            settingsSection = 2;
            accessLoaded    = TRUE;
            settingsKey     = llGetNotecardLine("Access List", settingsLine);
            
            return TRUE;
        } else {
            Keys            = [];
            accessLoaded    = FALSE;
            llMessageLinked(LINK_ALL_OTHERS, 0, "", "getkeys");
            return FALSE;
        }
    }
    
    return FALSE;
}


default
{
    state_entry()
    {
        loadSettings();
    }
    
    dataserver(key qid, string data)
    {
        if (qid == settingsKey) {
            if (data != EOF) {
                if (settingsLine == 0 && settingsSection == 2) {
                    Keys = [];
                    llMessageLinked(LINK_ALL_OTHERS, 0, "", "clearkeys");
                    llSleep(1.0);
                }

                data = trimString(data);
                
                if (data != "" && llStringLength(data) > 0) {
                    if (settingsSection == 1) {
                        list part = llParseString2List(data, ["="], []);
                        
                        if (llToLower(llList2String(part, 0)) == "time") {
                            if (llList2Float(part, 1) > 0 && llList2Float(part, 1) <= 10)
                                configRotTime = llList2Float(part, 1);
                        }
                        else if (llToLower(llList2String(part, 0)) == "steps") {
                            if (llList2Integer(part, 1) > 0)
                                configRotSteps = llList2Integer(part, 1);
                        }
                        else if (llToLower(llList2String(part, 0)) == "angle") {
                            if (llAbs(llList2Integer(part, 1)) > 0 && llAbs(llList2Integer(part, 1)) < 360)
                                configRotAngle  = llList2Integer(part, 1);
                        }
                        else if (llToLower(llList2String(part, 0)) == "axis") {
                            if (llListFindList(["x", "X", "y", "Y", "z", "Z"], llList2List(part, 1, 1)) >= 0) {
                                configAxis = llToLower(llList2String(part, 1));
                            }
                        }
                        else if (llToLower(llList2String(part, 0)) == "autoclose") {
                            if (llList2Float(part, 1) >= 0 && llList2Float(part, 1) <= 300)
                                configAutoClose = llList2Float(part, 1);
                        }
                        else if (llToLower(llList2String(part, 0)) == "touchdist") {
                            if (llList2Float(part, 1) > 0) {
                                configDistance = llList2Float(part, 1);
                            } else {
                                configDistance = 2.0;
                            }
                        }
                        else if (llToLower(llList2String(part, 0)) == "collision") {
                            if (llList2Integer(part, 1) >= 0)
                                configCollide = llList2Integer(part, 1);
                        }
                        else if (llToLower(llList2String(part, 0)) == "sensor") {
                            if (llList2Integer(part, 1) >= 1)
                                configSensor = llList2Integer(part, 1);
                        }
                        else if (llToLower(llList2String(part, 0)) == "double_name") {
                            if (llStringLength(llList2String(part, 1)) > 0) {
                                configDouble = llList2String(part, 1);
                            } else {
                                configDouble = "";
                            }
                        }
                        else if (llToLower(llList2String(part, 0)) == "sound_open") {
                            soundOpen = llList2String(part, 1);
                        }
                        else if (llToLower(llList2String(part, 0)) == "sound_close") {
                            soundClose = llList2String(part, 1);
                        }
                        else if (llToLower(llList2String(part, 0)) == "sound_knock") {
                            soundKnock = llList2String(part, 1);
                        }
                        else if (llToLower(llList2String(part, 0)) == "sound_lock") {
                            soundLock = llList2String(part, 1);
                        }
                        else if (llToLower(llList2String(part, 0)) == "sound_unlock") {
                            soundUnlock = llList2String(part, 1);
                        }
                    }
                    else if (settingsSection == 2) {
                        //llOwnerSay("DEBUG: loadSecttion 2 line: " + (string)settingsLine);
                        //if (settingsLine == 0) {
                        //    llOwnerSay("DEBUG: clearing keys");
                        //    Keys = [];
                        //    llMessageLinked(LINK_ALL_OTHERS, 0, "", "clearkeys");
                        //    llSleep(1.0);
                        //}
                        addKey(data, TRUE);
                    }
                }

                if (settingsSection == 1)
                    settingsKey = llGetNotecardLine("Settings", ++settingsLine);
                else
                    settingsKey = llGetNotecardLine("Access List", ++settingsLine);
                //settingsKey = llGetNotecardLine("Access List", ++settingsLine);
            } else {
                if (settingsSection == 1) {
                    llSay(0, "Settings loaded.");
                    loadSettings(2);
                } else {
                    llSay(0, "Access List loaded. " + (string)llGetListLength(Keys) + " with access.");
                }
            }
        }
    }
    
    changed(integer change)
    {
        if (change & CHANGED_INVENTORY) {
            loadSettings();
        }
    }
    
    touch_start(integer total_number)
    {
        if (llVecDist(llGetPos(), llDetectedPos(0)) <= configDistance) {
            llResetTime();
            if (touchDrag) touchDrag = FALSE;
        }
    }
    
    touch(integer total_number)
    {
        if (llVecDist(llGetPos(), llDetectedPos(0)) <= configDistance) {
            if (llGetTime() >= 0.25 && !touchDrag) {
                touchDrag = TRUE;
            }
        }
    }
    
    touch_end(integer total_number)
    {
        if (llVecDist(llGetPos(), llDetectedPos(0)) <= configDistance) {
            if (touchDrag && doorClosed) {
                if (llListFindList(Keys, [ llDetectedName(0) ]) > -1) {
                    if (doorLock)   lock(FALSE, llDetectedName(0));
                    else            lock(TRUE, llDetectedName(0));
                }
                llSetTimerEvent(0.0);
                touchDrag = FALSE;
            }
            else if (touchDrag && !doorClosed) {
                llSetTimerEvent(0.0);
                touchDrag = FALSE;
            }
            else if (llGetTime() >= 1 && doorClosed) {
                sound(soundKnock);
                llSay(0, llDetectedName(0) + " knocks.");
                llSetTimerEvent(0.0);
            }
            else {
                if (!doorLock) {
                    if (doorClosed) door(llDetectedKey(0), llVecDist(llGetPos(), llDetectedPos(0)));
                    else            door();
                }
                else {
                    sound(soundKnock);
                    llSay(0, llDetectedName(0) + " knocks.");
                }
            }
        }
    }
    
    collision_start(integer total_number)
    {
        if (llDetectedType(0) & AGENT)
            if (!doorLock && doorClosed && configCollide) door();
    }
    
    link_message(integer sender, integer num, string name, key id)
    {
        if (llStringLength(configDouble) > 0 && name == configDouble) {
            if (id == "door") {
                if (num != doorClosed) {
                    if (doorClosed) {
                        door();
                        llSetTimerEvent(0.0);
                    }
                    else {
                        llSetTimerEvent(0.0);
                        door();
                    }
                }
            }
            else if (id == "lock") {
                doorLock = num;
            }
        }
        if (!accessLoaded) {
            if (id == "clearkeys") {
                Keys = [];
            }
            else if (id == "addkey") {
                addKey(name, FALSE);
            }
            else if (id == "getkeys") {
                integer i;
                
                for (i = 0; i < llGetListLength(Keys); i++) {
                    llMessageLinked(sender, 1, llList2String(Keys, i), "addkey");
                }
            }
        }
    }
    
    no_sensor()
    {
        if (!doorClosed) {
            llSensorRemove();
            door();
        }
    }
    
    timer()
    {
        llSetTimerEvent(0.0);
        if (!doorClosed) door();
    }
}
