// Character Tool 1.2
// by Reynard Baroque
// 12 Jan 2010

// revisions
// 1.0 - original
// 1.1 - bug fix - menu commands sometimes being echoed in local chat; also added 'debug' command for assist
// 1.2 - bug fix - still getting menu echo in local chat; went to a single, fixed channel.

//
// DECLARE GLOBAL CONSTANTS
//
integer _DIALOG_CHANNEL = -1298198;        // communication channel between RP Tool and menu dialog
integer _DATA_NAME = 1;                    // listening for a player name
integer _DATA_CHANNEL = 2;                 // listening for a command channel
integer _DATA_LINE = 4;                    // listening for a titler line
integer _DATA_COLOR = 8;                   // listening for a titler colour
float _SOLID = 1.0;                        // setting for fully solid
vector _COLOR_BLACK = <0.0, 0.0, 0.0>;
vector _COLOR_WHITE = <1.0, 1.0, 1.0>;
vector _COLOR_DARK_GREY = <0.333, 0.333, 0.333>;
vector _COLOR_LIGHT_GREY = <0.667, 0.667, 0.667>;
vector _COLOR_DARK_RED = <0.5, 0.0, 0.0>;
vector _COLOR_LIGHT_RED = <1.0, 0.333, 0.333>;
vector _COLOR_DARK_GREEN = <0.0, 0.5, 0.0>;
vector _COLOR_LIGHT_GREEN = <0.333, 1.0, 0.333>;
vector _COLOR_DARK_BLUE = <0.0, 0.0, 0.5>;
vector _COLOR_LIGHT_BLUE = <0.333, 0.333, 1.0>;
vector _COLOR_DARK_YELLOW = <0.5, 0.5, 0.0>;
vector _COLOR_LIGHT_YELLOW = <1.0, 1.0, 0.333>;
vector _COLOR_DARK_CYAN = <0.0, 0.5, 0.5>;
vector _COLOR_LIGHT_CYAN = <0.333, 1.0, 1.0>;
vector _COLOR_DARK_MAGENTA = <0.5, 0.0, 0.5>;
vector _COLOR_LIGHT_MAGENTA = <1.0, 0.333, 1.0>;
//
// DECLARE GLOBAL VARIABLES
//

string playerSex = "unknown";              // "unknown" only until player selectes sex; after that, "boy" or "girl"
string playerPronoun = "its";              // "its" only until player selects sex; after that, "his" or "her"
string playerName = "Ima Player";          // default player name
string playerTitler = "Ima Player";          // flip titler is the same as the player name as a minimum
string playerData;                         // text of remainder of titler
vector flipTitlerColor = <1.0, 1.0, 1.0>;  // flip titler colour is white to start with
integer flipTitlerDark = FALSE;            // flip titler is set to dark colours when TRUE
float flipTitlerAlpha = 1.0;            // flip titler transparency setting
integer spoofDetect = FALSE;               // spoofing detection mode is off by default
integer ch0Handle;                         // listen handle for local chat
integer commandHandle;                     // listen handle for commands to rp tool
integer commandChannel = 33;               // RP tool will listen on this channel; set to 33 initially
integer dialogHandle;                      // listen handle for rp tool dialog menu
integer hearData = FALSE;                  // TRUE when we are listening for player data
string text;                               // text passed to pop function
string menuMsg;                            // text to pass to the dialog menu
list mainMenuActions = [ "Anti-Spoof", "Notecard", "[RESET]", "Boy/Girl", "Add Line", "Clear Title", "Set Name", "Set Channel", "Set Colour" ];
list colorMenuChoices = [ "<<== BACK", "Custom", "Light/Dark", "Black", "Grey", "White", "Yellow", "Cyan", "Magenta", "Red", "Blue", "Green" ];
list confirmChoices = [ "Reset", "Don't Reset" ];
//
// DEFINE USER FUCTIONS
//

//
// random number generator
// gnerates a random integer between min and max.
// note if min is > max, function will fail
//
// integer random_integer( integer min, integer max )
// {
//   return min + (integer)( llFrand( max - min + 1 ) );
// }

//
// Construct the dialog menu message according to which menu is required, then call the listen
// and dialog menu. Valid menus are "main", "colour" and "confirm"
//
CharacterToolMenu( string menu )
{
    // construct the message to go in the dialog box
    if( menu == "colour" )
    {
        menuMsg = "Select the desired colour. You can select one of the pre-defined colours, switch between light and dark, or enter a custom colour";
        llDialog( llGetOwner(), menuMsg, colorMenuChoices, _DIALOG_CHANNEL );
    }
    else if( menu == "main" )
    {
        if( spoofDetect )
        {
            menuMsg = "\nSpoof detection is ON";
        }
        else
        {
            menuMsg = "\nSpoof detection is OFF";
        }
        menuMsg += "\nCharacter gender: " + playerSex;
        menuMsg += "\nCommand channel: " + (string)commandChannel;

        llDialog( llGetOwner(), menuMsg, mainMenuActions, _DIALOG_CHANNEL );
    }
    else if( menu == "confirm" )
    {
        menuMsg = "Click on \"Reset\" to restore the Character Tool's default settings.\nClick on \"Do Not Reset\" to keep your current settings.";

        llDialog( llGetOwner(), menuMsg, confirmChoices, _DIALOG_CHANNEL );
    }

    // remove the old dialog listen handle
    llListenRemove( dialogHandle );

    // set the dialog menu communication listening handle
    dialogHandle = llListen(_DIALOG_CHANNEL, "", llGetOwner(), "");
}

//
// myTalk whispers, says or shouts 'objectName' followed by 'msg'. Orginal object name is stripped off, and which speaking
// function is used is passed as 'volume'.
//
// e.g., myTalk ( "Alan Avatar's Box", "whisper", "Can you hear me now?" ) will emit
//    Alan Avatar's Box whispers: Can you hear me now?
// in local chat.
//
myTalk(string objectName, string volume, string msg)
{
    string realname = llGetObjectName();    // save the real name of the speaking object
    llSetObjectName( objectName );          // re-name the speaking object to what was passed
    if( llToLower(volume) == "whisper" )
    {
        llWhisper( 0, msg );                // whisper the message; it will be heard only within 10 m of the speaking object.
    }
    else if( llToLower(volume) == "shout" )
    {
        llShout( 0, msg );                  // shout the message; it will be heard 100 m of the speaking object.
    }
    else
    {
        llSay( 0, msg );                    // say the mssage; it will be heard within 20 m of the speaking object.
    }
    llSetObjectName( realname );            // return the object to its real name
}

//
// myOwnerSay says the contents of 'msg' on owner channel with object name stripped off.
//
myOwnerSay(string msg)
{
    string name = llGetObjectName();
    llSetObjectName("");
    llOwnerSay( "/me " + msg);
    llSetObjectName(name);
}

//
// extracts the first word in a string.
//
// Form: string command = pop();
//
// source text resides in global variable "text".
// The first word (all characters up to the first space character)
// is extracted and returned in "result"; note that this word is
// stripped out of "text".
//
// e.g. - "the door opens" is passed to the function;
// command will contain "the";
// text will *now* contain "door opens". "the " has been stripped
// off the front of it.
//
// From a door script; author unknown, but very much appreciated!
//
string pop()
{
    string result;
    integer i = llSubStringIndex(text, " ");

    if( i!=-1 )
    {
        i -=1;
        result = llGetSubString(text,0,i);
        text = llGetSubString(text,i+2,-1);
        return result;
    }
    else
    {
        result = text;
        text = "";
    }

    text = llStringTrim(text, STRING_TRIM);
    result = llStringTrim(result, STRING_TRIM);

    return result;
}

//
// BEGIN SCRIPT
//
default
{
    on_rez(integer param)
    {
        // say the startup message
        myOwnerSay( "[Say 'ctool' on channel " + (string)commandChannel + " to show the Character Tool menu.]" );

        // set initial title
        llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

//        // generate a unique dialog chat channel number
//        do
//        {
//            _DIALOG_CHANNEL = ((integer)("0x"+llGetSubString((string)llGetKey(),-8,-1)) & 0x3FFFFFFF) ^ 0xBFFFFFFF;
//        }
//        while( _DIALOG_CHANNEL > -1 && _DIALOG_CHANNEL < -2147483648 );
//        do
//        {
//            _DIALOG_CHANNEL = random_integer( -2147483648, -1000 );
//        }
//        while( _DIALOG_CHANNEL > -1000 && _DIALOG_CHANNEL < -1000 )
    }

    state_entry()
    {
        // start listening on the command channel to the RP Tool's owner only.
        commandHandle = llListen( commandChannel, "", llGetOwner(), "" );
    }

    listen(integer channel, string name, key id, string message)
    {
        if( channel == commandChannel )    // if we heard something from the owner on the command channel
        {
            // copy the message to the text variable, so we can pop the first word
            text = message;

            // go get the first word and truncate the rest of the string
            string command = pop();

            // convert it to lower case for further processing
            command = llToLower( command );

            if( command == "ctool" )    // command was addressed to the RP tool
            {
                CharacterToolMenu( "main" );    // set the message and call the appropriate dialog box
            }
            else if( command == "shout" )    // shout the remaining text
            {
                myTalk( playerName, "shout", text );
            }
            else if( command == "whisper" )    // whisper the remaining text
            {
                myTalk( playerName, "whisper", text );
            }
            else if( command == "handup" )    // ignore the remaining text, emote raising player's hand
            {
                myTalk( playerName, "say", "/me raises " + playerPronoun + " hand. " );
                llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION);
            }
            else if( command == "handdown" )    // ignore the remaining text, emote lowering the player's hand
            {
                llStopAnimation( "armraise" );
                myTalk( playerName, "say", "/me lowers " + playerPronoun + " hand. " );
            }
            else if( command == "ooc" )    // offset the remaining text with OOC markers.
            {                              //     NOTE: OOC can only be say (20 m), not shout or whisper
                myTalk( playerName + " OOC", "say", "((" + text + "))" );
            }
            else if( command == "help" )    // display brief help message
            {
                myOwnerSay( "[Chat-based commands: shout, whisper, ooc, handup, handdown, spoof, ctool, help]" );
                myOwnerSay( "[Press 'Notecard' on the control menu for a copy of the instructions.]" );
            }
            else if( command == "debug" )    // report all operating variables
            {
                myOwnerSay( "DEBUG: Copy all lines beginning with the word DEBUG into a notecard and send it to Reynard Baroque." );
                myOwnerSay( "DEBUG: Owner: " + llKey2Name( llGetOwner()) );
                myOwnerSay( "DEBUG: variable: playerSex --- value: " + playerSex );
                myOwnerSay( "DEBUG: variable: playerPronoun --- value: " + playerPronoun );
                myOwnerSay( "DEBUG: variable: playerName -- value: " + playerName );
                myOwnerSay( "DEBUG: variable: playerData -- value: " + playerData );
                myOwnerSay( "DEBUG: variable: playerTitler -- value: " + playerTitler );
                myOwnerSay( "DEBUG: variable: flipTitlerColor -- vvalue: " + (string)flipTitlerColor );
                myOwnerSay( "DEBUG: variable: flipTitlerDark -- value: " + (string)flipTitlerDark );
                myOwnerSay( "DEBUG: variable: flipTItlerAlpha -- value: " + (string)flipTitlerAlpha );
                myOwnerSay( "DEBUG: variable: spoofDetect -- value: " + (string)spoofDetect );
                myOwnerSay( "DEBUG: variable: ch0Handle -- value: " + (string)ch0Handle );
                myOwnerSay( "DEBUG: variable: commandHandle -- value: " + (string)commandHandle );
                myOwnerSay( "DEBUG: variable: commandChannel -- value: " + (string)commandChannel );
                myOwnerSay( "DEBUG: variable: dialogHandle -- value: " + (string)dialogHandle );
                myOwnerSay( "DEBUG: variable: _DIALOG_CHANNEL -- value: " + (string)_DIALOG_CHANNEL );
                myOwnerSay( "DEBUG: variable: hearData -- value: " + (string)hearData );
                myOwnerSay( "DEBUG: variable: menuMsg -- value: " + (string)menuMsg );
                myOwnerSay( "DEBUG:\nDEBUG: End debug report." );                
            }
            
            else if( command == "spoof" )    // ignore the remaining text, show owners of other tools
            {                                 //    speaking, to defeat spoofing
                if( spoofDetect )    // spoof detection is ON
                {
                    // spoof flag to indicate spoof detection now OFF
                    spoofDetect = FALSE;

                    // stop listening to channel 0
                    llListenRemove( ch0Handle );

                    // tell the owner spoof detection has been turned off
                    myOwnerSay( "[Spoof detection mode is now OFF.]" );
                }
                else    // spoof detection is OFF
                {
                    // spoof flag to indicate spoof detection now ON
                    spoofDetect = TRUE;

                    // start listening to everything on channel 0
                    ch0Handle = llListen( 0, "", NULL_KEY, "" );

                    // tell the owner spoof detection has been turned on
                    myOwnerSay( "[Spoof detection mode is now ON.]" );
                }
            }
            else    // first word was not a valid command, so simply say the text.
            {
                if( hearData )    // we're listening for data
                {
                    if( hearData == _DATA_NAME )
                    {
                        // copy the new player name
                        playerName = message;

                        // construct the revised flip titler information
                        playerTitler = playerName + "\n" + playerData;

                        // display the new titler
                        llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                        // tell the owner that the new name is set
                        myOwnerSay( "[Titler name now set to: " + playerName + "]" );

                        // stop listening for data
                        hearData = FALSE;
                    }
                    else if( hearData == _DATA_LINE )
                    {
                        // append the line to the existing player data
                        if( playerData == "" )
                        {
                            playerData = message;
                        }
                        else
                        {
                            playerData += "\n" + message;
                        }

                        // construct the revised flip titler information
                        playerTitler = playerName + "\n" + playerData;

                        // display the new titler
                        llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                        // stop listening for data
                        hearData = FALSE;
                    }
                    else if( hearData == _DATA_CHANNEL )
                    {
                        // convert the string to an integer; any non-numeric figures will make it 0
                        integer temp_channel = (integer)message;

                        if( temp_channel <= 0 )    // if the number is 0 (local chat) or negative
                        {
                            myOwnerSay( "[Sorry, that's not a valid channel number. Please try again.]" );
                        }
                        else    // it's a valid channel number
                        {
                            // copy the channel value
                            commandChannel = temp_channel;

                            // tell the user the new command channel number
                            myOwnerSay( "[Command channel is now set to " + (string)temp_channel + "]" );

                            // close listen on old command channel
                            llListenRemove( commandHandle );

                            // open the new command channel
                            commandHandle = llListen( commandChannel, "", llGetOwner(), "" );

                            // stop listening for data
                            hearData = FALSE;
                        }
                    }
                    else if( hearData == _DATA_COLOR )
                    {
                        string temp_red = "";
                        string temp_green = "";
                        string temp_blue = "";
                        
                        text = message;
                        
                        temp_red = pop();
                        temp_green = pop();
                        temp_blue = pop();
                        
//                        llOwnerSay( "\nDEBUG: red value [" + temp_red + "] --- green value [" + temp_green + "] --- blue value [" + temp_blue + "]" );
                        
                        if(( temp_red == "" ) | ( temp_green == "" ) | ( temp_blue == "" )) // user didn't say enough elements separated by spaces.
                        {
                            myOwnerSay( "[You need to specify a colour value for all three colour components. Please try again.]" );
                        }
                        else    // we have 3 items now. Convert them to numbers.
                        {
                            integer ired = (integer)temp_red;
                            integer igreen = (integer)temp_green;
                            integer iblue = (integer)temp_blue;
                            
                            float red = (float)temp_red;        // convert them to floats. If there is any non-numeric character, the conversion
                            float green = (float)temp_green;    // will result in 0
                            float blue = (float)temp_blue;
                            
//                            llOwnerSay( "\nDEBUG: red value = " + (string)red + " --- green value = " + (string)green + " --- blue value = " + (string)blue );
                            
                            if(( red < 0.0 ) | ( red > 255.0 ) | ( green < 0.0 ) | ( green > 255.0 ) | ( blue < 0.0 ) | ( blue > 255.0 )) // a colour is out of range
                            {
                                myOwnerSay( "[Each colour value must be from 0 to 255. Values less than 0 or larger than 255 will not work. Please try again.]" );
                            }
                            else    // colour data is in range, so convert it to a colour vector and apply it.
                            {
                                red /= 255.0;
                                green /= 255.0;
                                blue /= 255.0;
                                
                                vector new_color = <red, green, blue>;
                                
//                                llOwnerSay( "\nDEBUG: final colour vector: " + (string)new_color );

                                flipTitlerColor = new_color;
                                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );
                                myOwnerSay( "[Colour has been set to RGB value " + (string)ired + ", " + (string)igreen + ", " + (string)iblue + ".]" );
                                
                                // stop listening for data
                                hearData = FALSE;
                            }
                        }
                    }
                }
                else    // we're not listening for data, so just say what was heard
                {
                    myTalk( playerName, "say", message );
                }
            }
        }
        else if( channel == _DIALOG_CHANNEL )    // dialogue menu channel interaction
        {
            if( message == "Anti-Spoof" )
            {
                if( spoofDetect )
                {
                    // spoof flag to indicate spoof detection now OFF
                    spoofDetect = FALSE;

                    // stop listening to channel 0
                    llListenRemove( ch0Handle );

                    // tell the owner spoof detection has been turned off
                    myOwnerSay( "[Spoof detection mode is now OFF.]" );
                }
                else
                {
                    // spoof flag to indicate spoof detection now ON
                    spoofDetect = TRUE;

                    // start listening to everything on channel 0
                    ch0Handle = llListen( 0, "", NULL_KEY, "" );

                    // tell the owner spoof detection has been turned on
                    myOwnerSay( "[Spoof detection mode is now ON.]" );
                }

                CharacterToolMenu( "main" );
            }
            else if( message == "Notecard" )
            {
                string temp_notecard_name = llGetInventoryName( INVENTORY_NOTECARD, 0 );
                llGiveInventory( llGetOwner(), temp_notecard_name );
            }
            else if( message == "[RESET]" )
            {
                // call the confirmation menu to double-check that resetting is what we want to do
                CharacterToolMenu( "confirm" );
            }
            else if( message == "Boy/Girl" )
            {
                if( playerSex == "boy" )    // if gender is set to boy
                {
                    playerSex = "girl";
                    playerPronoun = "her";
                }
                else    // otherwise it's girl or unknown
                {
                    playerSex = "boy";
                    playerPronoun = "his";
                }
                myOwnerSay( "[You're a " + playerSex + "!]" );

                CharacterToolMenu( "main" );
            }
            else if( message == "Add Line" )
            {
                // give the owner directions
                myOwnerSay( "[On channel " + (string)commandChannel + " say the line to add to your titler:]" );

                // select the line flag
                hearData = _DATA_LINE;

                CharacterToolMenu( "main" );
            }
            else if( message == "Clear Title" )
            {
                // set the titler to just the player name
                playerData = "";
                playerTitler = playerName + "\n" + playerData;

                // update the titler
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                myOwnerSay( "[Titler has been reset to your player name only.]" );

                CharacterToolMenu( "main" );
            }
            else if( message == "Set Name" )
            {
                // give the owner directions
                myOwnerSay( "[On channel " + (string)commandChannel + " say the new player name:]" );

                // select the name flag
                hearData = _DATA_NAME;

                CharacterToolMenu( "main" );
            }
            else if( message == "Set Channel" )
            {
                // give the owner directions
                myOwnerSay( "[On channel " + (string)commandChannel + " say the new command channel number:]" );

                // select the channel flag
                hearData = _DATA_CHANNEL;
            }
            else if( message == "Set Colour" )
            {
                CharacterToolMenu( "colour" );
            }
            else if( message == "<<== BACK" )
            {
                CharacterToolMenu( "main" );
            }
            else if( message == "Custom" )
            {
                // give the owner directions
                myOwnerSay( "[On channel " + (string)commandChannel + " say the RGB colour values for your custom colour, separated by spaces]" );
                myOwnerSay( "[e.g., yellow is RGB value 255/255/0, so you would say '/" + (string)commandChannel + " 255 255 0'.]" );

                // select the line flag
                hearData = _DATA_COLOR;

                CharacterToolMenu( "colour" );
            }
            else if( message == "Light/Dark" )
            {
                if( flipTitlerDark )
                {
                    flipTitlerDark = FALSE;

                    if( flipTitlerColor == _COLOR_DARK_GREY ) flipTitlerColor = _COLOR_LIGHT_GREY;
                    if( flipTitlerColor == _COLOR_DARK_RED ) flipTitlerColor = _COLOR_LIGHT_RED;
                    if( flipTitlerColor == _COLOR_DARK_GREEN ) flipTitlerColor = _COLOR_LIGHT_GREEN;
                    if( flipTitlerColor == _COLOR_DARK_BLUE ) flipTitlerColor = _COLOR_LIGHT_BLUE;
                    if( flipTitlerColor == _COLOR_DARK_YELLOW ) flipTitlerColor = _COLOR_LIGHT_YELLOW;
                    if( flipTitlerColor == _COLOR_DARK_CYAN ) flipTitlerColor = _COLOR_LIGHT_CYAN;
                    if( flipTitlerColor == _COLOR_DARK_MAGENTA ) flipTitlerColor = _COLOR_LIGHT_MAGENTA;
                }
                else
                {
                    flipTitlerDark = TRUE;

                    if( flipTitlerColor == _COLOR_LIGHT_GREY ) flipTitlerColor = _COLOR_DARK_GREY;
                    if( flipTitlerColor == _COLOR_LIGHT_RED ) flipTitlerColor = _COLOR_DARK_RED;
                    if( flipTitlerColor == _COLOR_LIGHT_GREEN ) flipTitlerColor = _COLOR_DARK_GREEN;
                    if( flipTitlerColor == _COLOR_LIGHT_BLUE ) flipTitlerColor = _COLOR_DARK_BLUE;
                    if( flipTitlerColor == _COLOR_LIGHT_YELLOW ) flipTitlerColor = _COLOR_DARK_YELLOW;
                    if( flipTitlerColor == _COLOR_LIGHT_CYAN ) flipTitlerColor = _COLOR_DARK_CYAN;
                    if( flipTitlerColor == _COLOR_LIGHT_MAGENTA ) flipTitlerColor = _COLOR_DARK_MAGENTA;
                }
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                CharacterToolMenu( "colour" );
            }
            else if( message == "Black" )
            {
                flipTitlerColor = _COLOR_BLACK;
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                CharacterToolMenu( "colour" );
            }
            else if( message == "Grey" )
            {
                if( flipTitlerDark )    // if titler is set to dark colours mode
                {
                    flipTitlerColor = _COLOR_DARK_GREY;
                }
                else
                {
                    flipTitlerColor = _COLOR_LIGHT_GREY;
                }

                // update the titler
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                CharacterToolMenu( "colour" );
            }
            else if( message == "White" )
            {
                flipTitlerColor = _COLOR_WHITE;
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                CharacterToolMenu( "colour" );
            }
            else if( message == "Yellow" )
            {
                if( flipTitlerDark )    // if titler is set to dark colours mode
                {
                    flipTitlerColor = _COLOR_DARK_YELLOW;
                }
                else
                {
                    flipTitlerColor = _COLOR_LIGHT_YELLOW;
                }

                // update the titler
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                CharacterToolMenu( "colour" );
            }
            else if( message == "Cyan" )
            {
                if( flipTitlerDark )    // if titler is set to dark colours mode
                {
                    flipTitlerColor = _COLOR_DARK_CYAN;
                }
                else
                {
                    flipTitlerColor = _COLOR_LIGHT_CYAN;
                }

                // update the titler
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                CharacterToolMenu( "colour" );
            }
            else if( message == "Magenta" )
            {
                if( flipTitlerDark )    // if titler is set to dark colours mode
                {
                    flipTitlerColor = _COLOR_DARK_MAGENTA;
                }
                else
                {
                    flipTitlerColor = _COLOR_LIGHT_MAGENTA;
                }

                // update the titler
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                CharacterToolMenu( "colour" );
            }
            else if( message == "Red" )
            {
                if( flipTitlerDark )    // if titler is set to dark colours mode
                {
                    flipTitlerColor = _COLOR_DARK_RED;
                }
                else
                {
                    flipTitlerColor = _COLOR_LIGHT_RED;
                }

                // update the titler
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                CharacterToolMenu( "colour" );
            }
            else if( message == "Blue" )
            {
                if( flipTitlerDark )    // if titler is set to dark colours mode
                {
                    flipTitlerColor = _COLOR_DARK_BLUE;
                }
                else
                {
                    flipTitlerColor = _COLOR_LIGHT_BLUE;
                }

                // update the titler
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                CharacterToolMenu( "colour" );
            }
            else if( message == "Green" )
            {
                if( flipTitlerDark )    // if titler is set to dark colours mode
                {
                    flipTitlerColor = _COLOR_DARK_GREEN;
                }
                else
                {
                    flipTitlerColor = _COLOR_LIGHT_GREEN;
                }

                // update the titler
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );

                CharacterToolMenu( "colour" );
            }
            else if( message == "Reset" )
            {
                // reset player sex information
                playerSex = "unknown";
                playerPronoun = "its";
                myOwnerSay( "[Player gender information reset.]" );
                
                // reset player titler information
                playerName = "Ima Player";
                playerData = "";
                playerTitler = playerName + "\n" + playerData;
                flipTitlerColor = _COLOR_WHITE;
                flipTitlerAlpha = _SOLID;
                flipTitlerDark = FALSE;
                
                // update the titler
                llSetText( playerTitler, flipTitlerColor, flipTitlerAlpha );
                myOwnerSay( "[Player titler information reset.]" );
                
                // reset spoof detection & command channel
                if( spoofDetect )
                {
                    // spoof flag to indicate spoof detection now OFF
                    spoofDetect = FALSE;

                    // stop listening to channel 0
                    llListenRemove( ch0Handle );
                }
                myOwnerSay( "[Spoof detection OFF.]" );

                // reset command channel to channel 33
                llListenRemove( commandHandle );
                commandChannel = 33;
                commandHandle = llListen( commandChannel, "", llGetOwner(), "" );
                hearData = FALSE;
                myOwnerSay( "[Command channel reset to channel 33.]" );

                myOwnerSay( "\n[Reset complete.]" );
            }
            else if( message == "Don't Reset" )
            {
                myOwnerSay( "[Cancelled reset. No changes made.]" );
            }
        }
        else    // otherwise it was on channel 0
        {
            if( spoofDetect == TRUE )     // is spoof detection mode on?
            {
                // get the UUID of the object that's speaking
                key objectkey = id;

                // get the name of the speaking object
                string objectname = llKey2Name( objectkey );

                // get the UUID of the object's owner
                key ownerkey = llGetOwnerKey( id );

                // get the name of the owner
                string ownername = llKey2Name( ownerkey );

                if( ownername != objectname )    // check if ownername is same as objectname;
                {                                //    if yes, it's an avatar speaking
                    // repeat what was heard, identifying the owner's SL name and the object's name
                    myOwnerSay( "<<" + ownername + ">> " + message );
                }
            }
        }
    }

    changed(integer mask)
    {   // Triggered when the object containing this script changes owner.
        if(mask & CHANGED_OWNER)
        {
            llResetScript();
        }
    }
    
    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION)
        {
            llStartAnimation("armraise");
        }
    }

}
