// Rakis Heron @ yeali.outworldz.net:8002

// Iris Door

float volume = 1.0;
integer maxcolliding = 50;//50 = 5.0 seconds (delay before door auto close and collide enable)
integer steps = 20;//20 = 2.0 seconds (door opening animation duration)
key startsound = "71c716e8-f84b-a682-2881-988f247a8c5f";
key stopsound = "242c084b-63c6-1879-fca4-379c93db9194";
key tex = "6a5b76ec-680d-9841-9d48-6e33c0f2bc6e";

//no edits below here
float interval = 0.1;
float rate = 1.0;
float ratio = 1.0;
float rf;
integer opened;
integer opening;
integer colliding;

open()
{
    float offset = -ratio;
    llSetLinkPrimitiveParamsFast(LINK_THIS, [PRIM_TYPE, PRIM_TYPE_TUBE, 0, <0.000000, 1.000000, 0.000000>, 0.000000, <0.000000, 0.000000, 0.000000>, <1.000000, 0.050000 + 0.450000*ratio, 0.000000>, <0.000000, 0.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, 1.000000, 0.000000, 0.000000, PRIM_TEXTURE, 3, tex, <1, 1, 0>, <offset, 0, 0>, -PI/2.0, PRIM_TEXTURE, 1, tex, <-1, 1, 0>, <offset, 0, 0>, PI/2.0, PRIM_TEXTURE, 2, tex, <1.0, 0.4, 0.0>, <-offset/2.0, 0, 0>, -PI/2.0, PRIM_TEXTURE, 0, tex, <1.0, 0.4, 0.0>, <-offset/2.0, 0, 0>, -PI/2.0]);
}

default
{
    state_entry()
    {
        open();
        llSetText("", <1, 1, 1>, 1);
        llSetTimerEvent(interval);
    }

    on_rez(integer param)
    {
        llResetScript();
    }

    touch_start(integer total_number)
    {
        if(opening)
            return;


        llTriggerSound(startsound, volume);
        opening = steps;
        if(opened)
        {
            rf = rate/(float)steps;
            colliding = 0;
        }
        else
        {
            rf = -rate/(float)steps;
            colliding = maxcolliding;
        }
    }

    timer()
    {
        if(opening)
        {
            opening--;
            ratio += rf;
            open();

            if(!opening)
            {
                llTriggerSound(stopsound, volume);
                opened = !opened;
            }
        }

        if(colliding && opened)
        {
            colliding--;
            if(!colliding)
            {
                llTriggerSound(startsound, volume);
                opening = steps;
                if(opened)
                {
                    rf = rate/(float)steps;
                }
            }
        }
    }

    collision_start(integer num)
    {
        if(opening)
            return;
        if(colliding)
            return;

        colliding = maxcolliding;

        llTriggerSound(startsound, volume);
        opening = steps;
        if(!opened)
        {
            rf = -rate/(float)steps;
        }
    }
} 