// Rakis Heron @ yeali.outworldz.net:8002

//XEngine
//Sliding door - simple

//Features:
//Works in Open Simulator based grids even when door is linked to other prims.
//Optional playing of sounds when the door opens or closes.
//Optional automatic closing of door using a timer.

//This script automatically adjusts for changes in position or rotation
//provided the changes occur while the door is in the closed position.

//Modified January 22, 2012 by Andrew Hellershanks
//Modified my Simple Door script to work with sliding doors.

//Modified: Added Sensor capabilities

// ********** USER SETTINGS BEGINS HERE **********

//The following vector specifies the distance (in meters) the door will
//move between the closed and open position. If door width is along the
//X axis, set the amount of movement in the first value of offset vector.
//If door width is along the Y axis, set the amount of movement in the
//second value of offset vector.
vector offset = <0.9, 0, 0>; // 0.9=90cm, change of direction 180°= -0.9

//These variables indicate if a sound file is to be played when the door
//is opened or closed. If the string is a name, the sound file needs to
//be found in the contents of the door prim. If the string is a key, any
//valid UUID for a sound file may be used. To disable playing sounds when
//the door opens or closes, use the empty string \"\".
string  SOUND_OPEN  = "slide_door_01"; //Sound when door opens
string  SOUND_CLOSE = "slide_door_01"; //Sound when door closes

//Automatically close the door after this many seconds.
//Use a value of 0 to stop the door from closing automatically.
float   TIMER_CLOSE = 10.0;

//Sensor Listen Channel make sure this matches what is in the volume detection sensor.
integer sensor_channel = 2525;
integer listen_handle;

// ********** END OF USER SETTINGS **********


integer DOOR_CLOSE  = 0;
integer DOOR_OPEN   = 1;

integer is_open     = FALSE;    

//In Second Life objects can move slightly from their position when rotated.
//This will keep track of the doors position to prevent it from moving.
vector  mypos;


door(integer action)
{
    if (action == DOOR_OPEN)
    {
        //Touching door twice in rapid succession makes it open more than once.
        //Prevent multiple rotations by checking to see if door is already open.
        if (is_open)
            return;

        is_open = TRUE;

        if (SOUND_OPEN != "")
            llTriggerSound(SOUND_OPEN, 0.8);
       
        mypos = llGetLocalPos();    //Remember original position of door

        llSetPos(mypos + offset*llGetLocalRot());

        if (TIMER_CLOSE > 0)
            llSetTimerEvent(TIMER_CLOSE);
    }
    else
    {
        //Touching door twice in rapid succession makes it close more than once.
        //Prevent multiple rotations by checking to see if door is already open.
        if (!is_open)
            return;

        if (TIMER_CLOSE > 0)
            llSetTimerEvent(0);

        is_open = FALSE;

        llSetPos(mypos);    //Workaround for tiny movements during rotation

        if (SOUND_CLOSE != "")
            llTriggerSound(SOUND_CLOSE, 0.8);
    }
}

default
{
    on_rez(integer start_params)
    {
        llResetScript();
    }
    
    state_entry()
        {
        listen_handle = llListen(sensor_channel, "", NULL_KEY, "");
    }    

    touch_start(integer total_number)
    {
        if (is_open)
            door(DOOR_CLOSE);
        else
            door(DOOR_OPEN);
    }

    collision(integer number)
    {
        door(DOOR_OPEN);
    }
    
    listen( integer channel, string name, key id, string message )
    {
        if (message == "door_open")
        {
            door(DOOR_OPEN);
        } 
    }     

    timer() // Time to close the door
    {
        door(DOOR_CLOSE);
    }
}
 