//// "Touch Toggle" CONTROLLER TEMPLATE v1 - by Jopsy Pendragon - 4/8/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// EFFECT: 'Touching' this prim will ACTIVATE or DEACTIVE particles.

// SETUP:  Drop this CONTROLLER TEMPLATE script into any prim of the same
// linked object as your PARTICLE TEMPLATE. It should be responsive immediately.

integer PLAY_SOUND = TRUE; // TRUE for a click-sound, FALSE for silent.
string  SOUND = "bac3e333-9624-4b1a-ade2-d2b01d5960aa"; // a click sound

string  CONTROLLER_ID = "A"; // see more about CONTROL TEMPLATES at end.

integer mode = 0; // keep track of whether particles are ON(1) or OFF(0).

default {
    
    touch_start(integer total_number) { 
    
        if ( PLAY_SOUND ) llPlaySound( SOUND, 0.5 );  
        
        mode = ! mode; // flip on to off, (or off to on).
        
        llMessageLinked( LINK_SET, mode, CONTROLLER_ID, NULL_KEY ); // send command
    }
    
    // Listen for other controllers sending ON/OFF commands and remember changes:
    link_message( integer sibling, integer num, string controller_id, key ignore ) {
        
        if ( controller_id != CONTROLLER_ID ) return; // this message is not for us.
        
        mode = num;
    }
}


//========================================================================
//======================== USING CONTROL TEMPLATES =======================
//
// By default one CONTROLLER TEMPLATE will activate and deactivate all the 
// PARTICLE TEMPLATES that are in the same linked object.
//
// However, the templates will only obey or affect each other if they share
// identical CONTROLLER_ID's.
//
// If you want templates to operate independently, change the value for 
// CONTROLLER_ID so that it is the same for all templates that work together.
// (and different from all the templates that it should ignore or be ignored by)

//==================================== END =============================== 