//MLP MULTI-LOVE-POSE V1.2 - Copyright (c) 2006, by Miffy Fluffy (BSD License)
integer i;
integer j;
integer line;
integer p;
list poses;
list positions;

default {
    state_entry() {
        llOwnerSay("Memory is empty, loading notecard: .POSITIONS");
        llGetNotecardLine(".POSITIONS",0);         // read first line of positions notecard
    }
     dataserver(key query_id, string data) {                                 
        if (data == EOF) state on;
        i = llSubStringIndex(data,"{");             //split name from positions, remove junk
        j = llSubStringIndex(data,"} <");
        if (i != -1 && j != -1) {
            poses += [ llGetSubString(data, i+1, j - 1) ];
            positions += [ llGetSubString(data, j+2, -1) ];
            //poses = [ llGetSubString(data, i+1, j - 1) ] + (poses = []) + poses;            //saves memory
            //positions = [ llGetSubString(data, j+2, -1) ] + (positions = []) + positions;   //saves memory
            //llSay(0,positions);
            ++p;   
        }
        ++line;
        llGetNotecardLine(".POSITIONS",line);       //read next line of positions notecard
    }
    state_exit() {
        llOwnerSay((string)p+" positions stored in memory ("+llGetScriptName()+": "+(string)llGetFreeMemory()+" bytes free)");
        if (p < 2) {
            poses = [ "stand","default" ];
            positions = [ "<-0.7,0.0,0.9> <0.0,0.0,0.0> <0.7,0.0,0.9> <0.0,0.0,-180.0>",
                          "<-0.7,0.0,0.7> <0.0,0.0,0.0> <0.7,0.0,0.7> <0.0,0.0,-180.0>" ];
            p = 2;
        }
        llMessageLinked(LINK_THIS,2,"OK",NULL_KEY); //msg to menu, in case it's waiting for loading
    }
}
state on {
    
    link_message(integer from, integer num, string str, key dkey) {
        if (str == "PRIMTOUCH"){
            return;
        }
        if (num != 1) return;        
        if (str == "OK?") {                                 //question from menu, before loading menu
            llMessageLinked(from,2,"OK",NULL_KEY);          //answer to menu
        } else if (str == "LOADED") {                       //msg from menu: loaded
            llMessageLinked(from,3,"LOADED",dkey);          //forward msg to pos
        } else if (str == "DUMP") {
            llOwnerSay("_______________________________________________________________________________");
            llOwnerSay("");
            llOwnerSay("Copy to notecard: .POSITIONS");
            llOwnerSay("_______________________________________________________________________________");
            llOwnerSay(""); 
            //for (i=0; i < p; ++i) llOwnerSay("{"+llList2String(poses,i)+"} "+llList2String(positions,i));
            for (i=p - 1; i>=0; --i) llOwnerSay("{"+llList2String(poses,i)+"} "+llList2String(positions,i));
        } else {
            i = llListFindList(poses,[ str ]);              //find pose
            if (llGetSubString((string)dkey,0,0) == "<") {  //SAVE
                if (i != -1) {
                    positions = llListReplaceList(positions,[ (string)dkey ],i,i);
                    llOwnerSay("{"+str+"} position updated in memory");
                } else {
                    //poses += [ str ];
                    //positions += [ (string)dkey ];
                    poses = [ str ] + (poses = []) + poses;                         //saves memory
                    positions = [ (string)dkey ] + (positions = []) + positions;    //saves memory
                    ++p;
                    llOwnerSay("{"+str+"} position added to memory");
                }
                llOwnerSay("("+llGetScriptName()+": "+(string)llGetFreeMemory()+" bytes free, "+(string)p+" positions)");
            } else {                                        //LOAD
                //if (i == -1) i = 0;                                         //not found, send default (-1 if save mem)     
                llMessageLinked(from,3,llList2String(positions,i),dkey);    //msg to pos: sent position
            } 
        }        
    }
}



