/////////////////////////////////////////////////
//                                             //
//            Created  by Jeff Cost            //
//            http://myopengrid.com            //
//                 License MIT                 //
//                                             //
///////////////////////////////////////////////// 

vector focus = <128., 142.895111, 28>;
vector pos = <124,170.75,27.0>;

setCameraPosition(integer perms)
{
    if(perms & PERMISSION_CONTROL_CAMERA)
    {
        vector camPos = pos;
        vector camFocus = focus;
        llClearCameraParams();
        llSetCameraParams([
            CAMERA_ACTIVE, 1,
            CAMERA_FOCUS, camFocus,
            CAMERA_FOCUS_LOCKED, TRUE,
            CAMERA_POSITION, camPos,
            CAMERA_POSITION_LOCKED, TRUE
        ]);
    }
}

default
{
    state_entry()
    {
        llSitTarget(<0.15,-0.6,0.3>, llEuler2Rot(<10.0,0.0,270.0>*DEG_TO_RAD));
    }
    changed(integer change)
    {
        if(change & CHANGED_LINK)
        {
            key agent = llAvatarOnSitTarget();

            if(agent)
            {
                llRequestPermissions(llAvatarOnSitTarget(), PERMISSION_CONTROL_CAMERA);
                llInstantMessage(llAvatarOnSitTarget(), "\n *** ATTENTION *** (hit esc for best camera viewing angle)\n ****************************************************************** \n For the best experience, enable automatic prim and parcel media under Edit > Preferences > Audio & Video tab > Check the *automatically play prim media* and *automatically play parcel media* boxes. \n\n ****************************************************************** \n ~to read this again check your local chat log. \n\n");
                
            }
        }
    }
    run_time_permissions(integer perms)
    {
        setCameraPosition(perms);
    }

}