// Lani Global Teleporter (c)2011 Lani Global
//  v5.4a
// Use of this script is on following conditions:
// Do not change this script.
// Do not change the copyright.
// Do not sell this script or teleporter.
// All rights reserved. 
// With thanks to Eric Marten for help with vectors
//====SCRIPT=====
//  
//Global Variables 
string anim = "teleport_stand3"; // teleport anim name  
integer owner_only = FALSE; //TRUE to only allow owner to Teleport. FALSE to allow anyone.
vector dest = <128,128,27>; //vector destination = (default) 
vector zeroPoint=<0,0,0>;//Set zero point to compensate for rotation of object prim
rotation sitrot = ZERO_ROTATION;    // sitting rotation 
vector CamPosOffset =<-0.3,-0.0,0>; //camera position offset
string slurl = "http://slurl.com/secondlife";
string teleback()
{
     string region = llGetRegionName();
     vector pos = llGetPos();
     string posx = (string)llRound(pos.x);
     string posy = (string)llRound(pos.y);
     string posz = (string)llRound(pos.z);
     vector posvectorzl = llGetPos()+ (<0,0,2>);
     string posz1 = (string)llRound(posvectorzl.z);
     
     return (" TeleBack: \n" + slurl + "/" + region + "/" + posx + "/" + posy +"/" + posz1);
 }
default
{
    
    on_rez(integer start_param) //when rezzed
    {
        llResetScript(); //reset script
    }
    
    state_entry() //normal operation state 
    {
        string DestD=llGetObjectDesc();
        list L1=llParseString2List(DestD,[" "],[]);
        dest.x=(float)llStringTrim(llList2String(L1,0),STRING_TRIM);
        dest.y=(float)llStringTrim(llList2String(L1,1),STRING_TRIM);
        dest.z=(float)llStringTrim(llList2String(L1,2),STRING_TRIM);
        zeroPoint=-llGetPos();
        vector relativePos=zeroPoint+dest; 
        vector target = relativePos;
        llSitTarget(target * (ZERO_ROTATION / llGetRot()),ZERO_ROTATION / llGetRot());
        llSetText("TELEPORT TO" + "\n " + llGetObjectName(),<1,1,1>,1); //sets floating text 
        llSetTextureAnim(ANIM_ON | SMOOTH | LOOP , ALL_SIDES, 1, 1, 1, 1, 0.1);//texture slide
        llSetTouchText("RESET"); //sets right click pie menu text touch
        llSetSitText("TELEPORT"); //sets right click pie menu text sit 
        llParticleSystem([]); //stop all particles
        llSay(0,teleback());
    }
    
    touch_start(integer num_detected) //when touched
    {
        llSetText("TELEPORTER\nDestination RESET to\n " + llGetObjectName() + "\n " + llGetObjectDesc(),<1,0.5,0>,1); 
        //sets floating text to show object description for RESET condition
        llSleep(5); //sleep to allow time to view RESET text
        llResetScript(); //reset the script to enable storing of vectors
    }

    changed(integer change) //changed state with avatar sitting
    {
        if(change & CHANGED_LINK && llAvatarOnSitTarget() != NULL_KEY) //avatar sit test
        {
            if(owner_only == FALSE) //owner test
            { 
            llRequestPermissions(llAvatarOnSitTarget(),PERMISSION_TRIGGER_ANIMATION | PERMISSION_CONTROL_CAMERA);//perms request 
            key id = llAvatarOnSitTarget(); 
            llSay(0," " + llKey2Name(llAvatarOnSitTarget()) + " is teleporting to " + llGetObjectName() + ".");
            llStopAnimation("sit"); //stops any previous sit animation of avatar
          //  llSleep(0.1); //sleep for time to allow anim to stop
            llStartAnimation(anim); //animate the avatar
          //  llSleep(0.1); //sleep for time to allow anim to start
            llStartAnimation(anim); //animate the avatar again to start in LAG conditions
            llSetCameraParams([
            CAMERA_ACTIVE, 1, // 1 is active, 0 is inactive
            CAMERA_BEHINDNESS_ANGLE, 0.0, // (0 to 180) degrees
            CAMERA_BEHINDNESS_LAG, 0.0, // (0 to 3) seconds
            CAMERA_DISTANCE, 0.2, // ( 0.5 to 10) meters
            CAMERA_FOCUS, llGetPos(), // region-relative position
            //CAMERA_FOCUS,<195.350,78.672,21.152>, // region-relative position
            CAMERA_FOCUS_LAG, 0.1 , // (0 to 3) seconds
            CAMERA_FOCUS_LOCKED, TRUE, // (TRUE or FALSE)
            CAMERA_FOCUS_THRESHOLD, 0.0, // (0 to 4) meters
            CAMERA_PITCH, 0.0, // (-45 to 80) degrees
            CAMERA_POSITION, llGetPos()-CamPosOffset, // region-relative position
            //CAMERA_POSITION,<195.35,79,21.152>, // region-relative position
            CAMERA_POSITION_LAG, 0.0, // (0 to 3) seconds
            CAMERA_POSITION_LOCKED, TRUE, // (TRUE or FALSE)
            CAMERA_POSITION_THRESHOLD, 0.0, // (0 to 4) meters
            CAMERA_FOCUS_OFFSET, ZERO_VECTOR // <-10,-10,-10> to <10,10,10> meters
            ]);
            llParticleSystem([ //start particles
            PSYS_PART_FLAGS, PSYS_PART_INTERP_COLOR_MASK | PSYS_PART_INTERP_SCALE_MASK ,
            PSYS_PART_START_COLOR, <1,1,1>, 
            PSYS_PART_START_ALPHA, 0.5, 
            PSYS_PART_END_COLOR, <0.0,0.2,1>, 
            PSYS_PART_END_ALPHA, 0.0, 
            PSYS_PART_START_SCALE, <0.001,0.001,0.001>, 
            PSYS_PART_END_SCALE, <1,1,2>, 
            PSYS_PART_MAX_AGE, 3,
            PSYS_SRC_ACCEL, <0.00,0.00,1>,  
            PSYS_SRC_PATTERN, PSYS_SRC_PATTERN_EXPLODE, 
            PSYS_SRC_BURST_RATE, 0.1,
            PSYS_SRC_BURST_PART_COUNT, 64, 
            PSYS_SRC_BURST_RADIUS, 0.2, 
            PSYS_SRC_BURST_SPEED_MIN, 0.01, 
            PSYS_SRC_BURST_SPEED_MAX, 0.01, 
            PSYS_SRC_TEXTURE, "starburst",
            PSYS_SRC_OMEGA, <0.00,0.00,0.00>
            ]);  
            llInstantMessage(id,teleback()); //send teleback IM to avatar
            llSleep(5); //sleep to allow particles view + time to teleport avatar to destination
            llUnSit(llAvatarOnSitTarget());  //unsit the avatar at the destination
            }
            else if(owner_only == TRUE && llAvatarOnSitTarget() != llGetOwner()) //Not Owner!
            {
                llUnSit(llAvatarOnSitTarget()); //unsit the avatar from teleporter
                llStopAnimation(anim); //stop anim the avatar
                llParticleSystem([]); //stop all particles
                llWhisper(0," Sorry, this Teleporter is set to allow Owner only."); //message to non-Owner
            }
        }
        if(llAvatarOnSitTarget() == NULL_KEY) //avatar sit?
        {
            llParticleSystem([]); //stop all particles
          //  llResetScript(); // reset the script
        }
    }
    
    run_time_permissions(integer perm) //permissions
    {
        if(llAvatarOnSitTarget() != NULL_KEY) //test for avatar sit?
        {
            if(perm) //permission test
            {
                llStopAnimation("sit"); //stop any avatar anims
                llSleep(0.1); //sleep for time to stop avatar anims
                llStartAnimation(anim); //animate the avatar
                llSleep(0.1); //sleep for time to start the anim
                llStartAnimation(anim); //animate the avatar again to start in LAG conditions
            }
            else if(!perm) //permissions test
            {
            llRequestPermissions(llAvatarOnSitTarget(),PERMISSION_TRIGGER_ANIMATION | PERMISSION_CONTROL_CAMERA);//sit anim perm and camera perm
            key id2 = llAvatarOnSitTarget();
            llSay(0," " + llKey2Name(llAvatarOnSitTarget()) + " is teleporting to " + llGetObjectName() + ".");
            llSetCameraParams([
            CAMERA_ACTIVE, 1, // 1 is active, 0 is inactive
            CAMERA_BEHINDNESS_ANGLE, 0.0, // (0 to 180) degrees
            CAMERA_BEHINDNESS_LAG, 0.0, // (0 to 3) seconds
            CAMERA_DISTANCE, 0.2, // ( 0.5 to 10) meters
            CAMERA_FOCUS, llGetPos(), // region-relative position
            CAMERA_FOCUS,<195.350,78.672,21.152>, // region-relative position
            CAMERA_FOCUS_LAG, 0.1 , // (0 to 3) seconds
            CAMERA_FOCUS_LOCKED, TRUE, // (TRUE or FALSE)
            CAMERA_FOCUS_THRESHOLD, 0, // (0 to 4) meters
            CAMERA_PITCH, 0.0, // (-45 to 80) degrees
            CAMERA_POSITION, llGetPos()-CamPosOffset, // region-relative position
            //CAMERA_POSITION,<195.35,79,21.152>, // region-relative position
            CAMERA_POSITION_LAG, 0.1, // (0 to 3) seconds
            CAMERA_POSITION_LOCKED, TRUE, // (TRUE or FALSE)
            CAMERA_POSITION_THRESHOLD, 0, // (0 to 4) meters
            CAMERA_FOCUS_OFFSET, ZERO_VECTOR // <-10,-10,-10> to <10,10,10> meters
            ]);
                 
            llParticleSystem([ //start particles
            PSYS_PART_FLAGS, PSYS_PART_INTERP_COLOR_MASK | PSYS_PART_INTERP_SCALE_MASK ,
            PSYS_PART_START_COLOR, <1,1,1>, 
            PSYS_PART_START_ALPHA, 0.5, 
            PSYS_PART_END_COLOR, <0.0,0.2,1>, 
            PSYS_PART_END_ALPHA, 0.0, 
            PSYS_PART_START_SCALE, <0.001,0.001,0.001>, 
            PSYS_PART_END_SCALE, <1,1,2>, 
            PSYS_PART_MAX_AGE, 3,
            PSYS_SRC_ACCEL, <0.00,0.00,1>,  
            PSYS_SRC_PATTERN, PSYS_SRC_PATTERN_EXPLODE, 
            PSYS_SRC_BURST_RATE, 0.1,
            PSYS_SRC_BURST_PART_COUNT, 64, 
            PSYS_SRC_BURST_RADIUS, 0.2, 
            PSYS_SRC_BURST_SPEED_MIN, 0.01, 
            PSYS_SRC_BURST_SPEED_MAX, 0.01, 
            PSYS_SRC_TEXTURE, "starburst",
            PSYS_SRC_OMEGA, <0.00,0.00,0.00>
            ]); 
            llSleep(5); //sleep to allow particles view + time to teleport avatar to destination
            llInstantMessage(id2,teleback()); //send teleback IM to avatar
            llUnSit(llAvatarOnSitTarget());  //unsit the avatar at the destination
            }
            else //otherwise
            {   
                llStopAnimation(anim); //stop animating the avatar
                llParticleSystem([]); //stop all particles
               // llResetScript(); //reset the script 
            }
        }
    }
    //end
}   