// The code below was generated by
// SCRATCH FOR SECOND LIFE (S4SL)
// alpha release October 19, 2007
//
// by Eric Rosenbaum (ericr@media.mit.edu)
// MIT Media Lab 
// Lifelong Kindergarten group
//
// S4SL is a modified version of Scratch, 
// a graphical programming language for kids
// see scratch.mit.edu
//

//
// USER VARIABLES
//


//
//  INTERNAL VARIABLES
//

vector home;
integer penState;
float penColor;
float color;
float ghost;
vector originalScale;
float sizePercent;
integer numAvatarsNearby;
vector nearestAvPosition;
key ownerKey;
vector ownerPosition;

//
//   INTERNAL FUNCTIONS
//

// move(steps)
// move object a number of steps (meters) along its current heading
// forward is along the positive x axis
// if the pen is down, create a line segment along the path traveled
// the line is positioned by its center, which is placed halfway back along the path
move(float steps) 
{
    vector fwd = llRot2Fwd(llGetRot()) * steps;
    llSetPos(llGetPos() + fwd);
    if (penState == TRUE) {
        if (llGetInventoryType("lineSegment") == INVENTORY_NONE) {
            llSay(0, "Oops! To draw a line, my inventory needs a lineSegment. You can get one from the Scratch Inventory Box.");
        } else { 
            integer randomID = llRound(llFrand(99999999));
               llRezObject("lineSegment", llGetPos()-fwd/2, <0,0,0>, llGetRot(), randomID);
               llSay(1, (string)randomID + ":set length:"+ (string)llFabs(steps));
               llSay(1, (string)randomID + ":set color:" + (string)penColor);
        }
    }
}
// turnRight(float angle)
// turn angle degrees clockwise around the local z axis
turnRight(float angle)
{
    angle *= -1;
    rotation newRot = llEuler2Rot(<0,0,angle> * DEG_TO_RAD);
    llSetRot(newRot*llGetRot());    
}
// turnLeft(float angle)
// turn angle degrees counterclockwise around the local z axis
turnLeft(float angle)
{ 
    rotation newRot = llEuler2Rot(<0,0,angle> * DEG_TO_RAD);
    llSetRot(newRot*llGetRot());    
}
//up(float steps)
//move up along the global z axis by steps meters
//does not leave a line segment
up(float steps)
{
    llSetPos(llGetPos()+<0,0,steps>);   
}
//down(float steps)
//move down along the global z axis by steps meters
//does not leave a line segment
down(float steps)
{
    llSetPos(llGetPos()+<0,0,-1*steps>);   
}
// turnPitch(float angle)
// turn angle degrees upward around the local y axis
turnPitch(float angle)
{
    angle *= -1;
    rotation newRot = llEuler2Rot(<0,angle,0> * DEG_TO_RAD);
    llSetRot(newRot*llGetRot());    
}
// float getHeading()
// return the current heading in the xy plane in degrees 
float getHeading() {
    return llRot2Angle(llGetRot())*RAD_TO_DEG;
}
// setHeading(float angle)
// set the heading in the xy plane in degrees
setHeading(float angle) {
    vector newVec = <0, 0, angle*DEG_TO_RAD>;
    rotation newRot = llEuler2Rot(newVec);
    llSetRot(newRot);   
}
// turnRoll(float angle)
// turn angle degrees clockwise around the local x axis
turnRoll(float angle)
{
    rotation newRot = llEuler2Rot(<angle,0,0> * DEG_TO_RAD);
    llSetRot(newRot*llGetRot());    
}
// changePenColorBy(float num)
// change the pen color by an amount
changePenColorBy(float num)
{
        penColor += num;
    setPenColorTo(penColor);
}
// setPenColorTo(float num)
// set the pen to a particular color
setPenColorTo(float num)
{
    penColor = (integer)num % 100;
}
// penDown()
// put the pen down, so that when the object moves it will draw
penDown() {
    penState = TRUE;
}
// penUp()
// put the pen up, so that the object will not draw when it moves
penUp() {
    penState = FALSE;
}
// clear()
// broadcast a message to nearby line segments that will cause them to 
// delete themselves
clear() {
    llSay(1, "clearLineSegments");
}
// pointTowardNearestAv()
// turn to point toward the nearest avatar
pointTowardNearestAv()
{
    vector myPos = llGetPos();
    float xdiff = myPos.x - nearestAvPosition.x;
    float ydiff = myPos.y - nearestAvPosition.y;
    float angle = llAtan2(xdiff, ydiff) * RAD_TO_DEG; 
    setHeading(270 - angle);
}
// pointTowardOwner()
// turn to point toward the owner
pointTowardOwner()
{
    vector myPos = llGetPos();
    float xdiff = myPos.x - ownerPosition.x;
    float ydiff = myPos.y - ownerPosition.y;
    float angle = llAtan2(xdiff, ydiff) * RAD_TO_DEG; 
    setHeading(270 - angle);
}
// float distanceToNearestAv()
// returns the distance in meters to the nearest avatar
float distanceToNearestAv()
{
    return llVecDist(llGetPos(), nearestAvPosition);
}
// float distanceToOwner()
// returns the distance in meters to the owner
float distanceToOwner()
{
    return llVecDist(llGetPos(), ownerPosition);
}
// float randomMinToMax(float min, float max)
// returns a random number between min and max
integer randomMinToMax(float min, float max)
{
    return llRound(llFrand(max - min) + min);
}
// say(string text) 
// say the text on the public chat channel 0 so all nearby avatars and objects will hear it
say(string text) 
{
    llSay(0, text);
}
// broadcast(string message)
// say the message on channel 1.  No avatars will hear it.
// all nearby objects will hear it.
broadcast(string message)
{
    llSay(1, message);
}
// setText(string text)
// create opaque white floating text above the object
setText(string text)
{
    llSetText(text, <1,1,1>, 1);
}
// vector hueToRGB(float h)
// take a color represented as a hue value between 1 and 100 and 
// return an RGB vector representing the same color.
vector hueToRGB(float h)
{
    integer i;
    float f;
    float p;
    float q;
    float t;
    float r;
    float g;
    float b;
    float s = 1;
    float v = 1;
    h *= 5;            // sector 0 to 5
    i = llFloor(h);
    f = h - i;            // factorial part of h
    p = v * ( 1 - s );
    q = v * ( 1 - s * f );
    t = v * ( 1 - s * ( 1 - f ) );

    if (i == 0) {
            r = v;
            g = t;
            b = p;
    } else if (i == 1) {
            r = q;
            g = v;
            b = p;
     } else if (i == 2) {
            r = p;
            g = v;
            b = t;
    } else if (i == 3) {
            r = p;
            g = q;
            b = v;
    } else if (i == 4) {
            r = t;
            g = p;
            b = v;
    } else {
            r = v;
            g = p;
            b = q;
    }
    return <r,g,b>;
}
// setColor(float num)
// set the color of the object using a number between 1 and 100 representing a hue
setColor(float num)
{
     color = (integer)num % 100;    
    llSetColor(hueToRGB(color / 100), ALL_SIDES);
    if (llGetObjectName() == "Scratch Bug") {
        llSetLinkColor(2, hueToRGB(color / 100), ALL_SIDES);
    } else {
        //llSetLinkColor(LINK_SET, hueToRGB(color / 100), ALL_SIDES);
    }
}
// changeColorBy(float num)
// change the hue of the object by a number
changeColorBy(float num)
{
    float newColor = color + num;
    if (newColor < 0) {
        newColor = 0;
    }
    if (newColor > 100) {
        newColor = 100;
    }
    setColor(newColor);
}
// setGhost(float num)
// set the ghost effect of the object to a value between 0 (opaque) and 100 (transparent)
setGhost(float num)
{
    ghost = (integer)num % 101;
    llSetAlpha(((100 - ghost) / 100), ALL_SIDES);
    llSetLinkAlpha(LINK_SET, ((100 - ghost) / 100), ALL_SIDES);
}
// changeGhostBy(float num) 
// change the ghost effect on an object by a number
changeGhostBy(float num) 
{
    setGhost(ghost + num);
}
// setSize(float newSize)
// set the size of the object to a percentage of its original size
setSize(float newSize)
{
    sizePercent = newSize;
    vector newScale = originalScale*(sizePercent/100); 
    llSetScale(newScale);
}
// changeSizeBy(float change)
// change the size of an object by a percentage of its original size
changeSizeBy(float change)
{
    sizePercent += change;
    vector newScale = originalScale*(sizePercent/100); 
    llSetScale(newScale);
}
// playSound(string snd)
// play a sound at full volume
// snd can be the name of a sound in the inventory of the object, or the
// UUID of a sound which exists somewhere else
playSound(string snd) 
{
    llPlaySound(snd, 1);
}
// playSoundNamed(string snd)
// play a sound at full volume
// snd can be the name of a sound in the inventory of the object, or the
// UUID of a sound which exists somewhere else
// this is the version for text input of the name of a sound in a scratch block
// so it checks the inventory and gives an error if the sound is missing
playSoundNamed(string snd) 
{
    if (llGetInventoryType(snd) == INVENTORY_NONE) {
        llSay(0, "Oops! My inventory does not contain the sound " + snd);
    } else { 
        llPlaySound(snd, 1);
    }
}
// wait(float secs)
// pause all execution of this script for some number of seconds
wait(float secs)
{
    llSleep(secs);
}
// levelOut()
// remove the x and y rotation components, so that the object is
// level with respect to the ground
levelOut()
{
    vector myVec = llRot2Euler(llGetRot());
    vector newVec = <0, 0, myVec.z>;
    rotation newRot = llEuler2Rot(newVec);
    llSetRot(newRot);
}
// goHome() 
// move the object back to its home position
// home is set the the position of the object when it is created,
// and can be set to a new position using setHomeHere()
goHome() 
{
    llSetPos(home);
    //levelOut();
}
// setHomeHere()
// set the home position to the current position
setHomeHere()
{
        home = llGetPos();
}
// startListening() 
// listen for messages on both channel 0, the public channel,
// and channel 1, where broadcasts are sent     
startListening() 
{
    llListen(0, "", "", "");
    llListen(1, "", "", "");
}   
// initInternal()
// do some setup for internal functions
// this includes setting various variables to their defaults
// clearing text on the object, and turning on
// the repeating sensor and timer events
initInternal()
{
       setHomeHere();
        penState = FALSE;
        penColor = 0;
       color = 0;
       ghost = 0;
        sizePercent = 100;
        originalScale = llGetScale();
       ownerKey = llGetOwner();
       llSetText("", <1,1,1>, 0);
       llSensorRepeat("", "", AGENT, 96, PI, .1);
       llSetTimerEvent(.1);
       startListening();
}
initAll() {
    initInternal();
}
touch1(){
   turnRight(30);
   wait(0.8);
   turnRight(30);
   wait(0.8);
   turnRight(30);
   wait(10);
   turnLeft(30);
   wait(0.8);
   turnLeft(30);
   wait(0.8);
   turnLeft(30);
}
default
{
    state_entry()
    {
        initAll();
    }
    on_rez(integer start_param)
    {
        initAll();
    }
    sensor(integer n)
    {
        numAvatarsNearby = n;
        nearestAvPosition = llDetectedPos(0);
        integer i;
        for (i=0; i<n; i++) {
            if (llDetectedKey(i) == ownerKey) {
                ownerPosition = llDetectedPos(i);
            }
        }
    }
    touch_start(integer n) {
        touch1();
    }
    collision_start(integer n) {
    }
    listen(integer channel, string name, key id, string msg) {
    }
    timer() {
    }

  }
//<?xml version="1.0" encoding="UTF-8" ?><scratchScript><block event="Scratch-MouseClickEvent"/><block selector="turnRight:"><argument>30</argument></block><block selector="wait:elapsed:from:"><argument>0.8</argument></block><block selector="turnRight:"><argument>30</argument></block><block selector="wait:elapsed:from:"><argument>0.8</argument></block><block selector="turnRight:"><argument>30</argument></block><block selector="wait:elapsed:from:"><argument>10</argument></block><block selector="turnLeft:"><argument>30</argument></block><block selector="wait:elapsed:from:"><argument>0.8</argument></block><block selector="turnLeft:"><argument>30</argument></block><block selector="wait:elapsed:from:"><argument>0.8</argument></block><block selector="turnLeft:"><argument>30</argument></block></scratchScript>
