// Created by Seagle Neville

vector sit_pos = <0, 0, 0.5>;
vector sit_rot = <0, 0, 0>;

string DISPLAY_TEXT = "Sit"; 
string ANIMATION;
integer is_sitting = FALSE;
integer anim_num;
integer fire_anim_num;

list SIT_ANIMATIONS = [];

RANDOM_SELECT_ANIMATION()
{
    anim_num = llGetInventoryNumber(INVENTORY_ANIMATION) - 1;  // Count from 0
    fire_anim_num = llRound(llFrand(anim_num));
}

SIT_ANIMATION()
{
    ANIMATION = llGetInventoryName(INVENTORY_ANIMATION, fire_anim_num);
}

default
{
    state_entry()
    {
        is_sitting = 0;
        llSitTarget(sit_pos, llEuler2Rot(sit_rot*DEG_TO_RAD));
        llSetText(DISPLAY_TEXT,<1,1,1>,1);
    }
    on_rez(integer start_param)
    {
        llResetScript();
    }
    changed(integer change)
    {
        if(change & CHANGED_LINK)
        {
            key av = llAvatarOnSitTarget();
            RANDOM_SELECT_ANIMATION();
            if(av != NULL_KEY)
            {
                llRequestPermissions(av, (PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS));
            }
            else
            {
                if((llGetPermissions() & (PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS)) && is_sitting)
                {
                    is_sitting = 0;
                    llStopAnimation(ANIMATION);
                    llSetText(DISPLAY_TEXT,<1,1,1>,1);
                    llReleaseControls();
                }
            }
        }
        SIT_ANIMATION();
    }
    run_time_permissions(integer perm)
    {
        if(perm & (PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS))
        {
            llTakeControls(CONTROL_RIGHT | CONTROL_LEFT, TRUE, FALSE);
            is_sitting = TRUE;
            llStopAnimation("sit_generic");
            llStopAnimation("sit");
            llStartAnimation(ANIMATION);
            llSetText("",<1,1,1>,1);
        }
    }
    control(key id, integer level, integer edge)
    {
//        llOwnerSay("fire_anim_num is " + (string)fire_anim_num);    //Debug
//        llOwnerSay("anim_num is " + (string)anim_num);    //Debug
        if(level & CONTROL_RIGHT)
        {
            llSleep(0.1);
            fire_anim_num = fire_anim_num + 1;
            if(fire_anim_num > anim_num)
            {
                fire_anim_num = 0;
            }
            llStopAnimation(ANIMATION);
            ANIMATION = llGetInventoryName(INVENTORY_ANIMATION, fire_anim_num);
            llStartAnimation(ANIMATION);
        }
        if(level & CONTROL_LEFT)
        {
            llSleep(0.1);
            fire_anim_num = fire_anim_num - 1;
            if(fire_anim_num < 0)
            {
                fire_anim_num = anim_num;
            }
            llStopAnimation(ANIMATION);
            ANIMATION = llGetInventoryName(INVENTORY_ANIMATION, fire_anim_num);
            llStartAnimation(ANIMATION);
        }
    }
}