
// Globals
float volume_min = 0.2;
float volume_max = 1.0;
float interval_min = 1.0;
float interval_max = 3.0;

// The inventory can have multiple sound files
// these should all have the same basic sound_name e.g. moo
// each file should have an index number starting from sound_index_first e.g. 1 => moo1.wav
// sound_index_last is the last in the list of files. e.g. 3 => moo3.wav

list sound_name = [];
integer sound_index = 0;
integer sound_select = 0;

// functions     
integer RandInt(integer n)
{
    return (integer)llFrand(n + 1);
}

integer RandIntBetween(integer min, integer max)
{
    return min + RandInt(max - min);
}

// float random number generator between min & max 
float RandFloatBetween(float min, float max)
{
    return llFrand(max - min) + min;
}

string Float2String ( float num, integer places, integer rnd) { 
    //allows string output of a float in a tidy text format
    //rnd (rounding) should be set to TRUE for rounding, FALSE for no rounding

    if (rnd) {
        float f = llPow( 10.0, places );
        integer i = llRound(llFabs(num) * f);
        string s = "00000" + (string)i; // number of 0s is (value of max places - 1 )
        if(num < 0.0)
            return "-" + (string)( (integer)(i / f) ) + "." + llGetSubString( s, -places, -1);
        return (string)( (integer)(i / f) ) + "." + llGetSubString( s, -places, -1);
    }
    if (!places)
        return (string)((integer)num );
    if ( (places = (places - 7 - (places < 1) ) ) & 0x80000000)
        return llGetSubString((string)num, 0, places);
    return (string)num;
}

list GetSoundInventory()
{
    // local variables
    integer inventory_sounds = 0;
    integer loop_index = 0;
    string sound_name = "";
    list sound_list = [];

    inventory_sounds = llGetInventoryNumber(INVENTORY_SOUND);
//    llSay(0, "There are " + (string)sound_files + " sounds in my contents.");

    // List the sounds in the inventory        
    if (inventory_sounds == 0)
    {
        llOwnerSay("There are no sounds available in the object inventory!");
        return sound_list;
    }
    else
    {
        while(loop_index != inventory_sounds)
        {
            sound_name = llGetInventoryName(INVENTORY_SOUND, loop_index);
            sound_list = sound_list + [sound_name];
//            llOwnerSay("I have a sound named " + name + " in my contents." + " loop_index = " + (string)loop_index);
//            llOwnerSay("Sound_List element " + (string)loop_index + " is named " +  llList2String(sound_list, loop_index));
            loop_index = loop_index + 1;
        }
        return sound_list;
    }
}

default
{
    state_entry()
    {
        // do nothing
    }
    touch_end(integer total_number)
    {
        llOwnerSay("Start Mooing!");
        state Moo;
    }
}
state Moo
{
    state_entry()
    {
// set up local inventory list
        sound_name = GetSoundInventory();
// set startup interval
        float random_interval = RandFloatBetween(interval_min, interval_max);
        string timer_interval = Float2String(random_interval, 2, TRUE);
// set start timeout        
        llSetTimerEvent(random_interval);
    }
    timer()
    {
// set new interval
        float random_interval = RandFloatBetween(interval_min, interval_max);
        string timer_interval = Float2String(random_interval, 2, TRUE);
// set new volume
        float random_volume = RandFloatBetween(volume_min, volume_max);
        string volume = Float2String(random_volume, 2, TRUE);
// set new timeout        
        llSetTimerEvent(random_interval);
// Play the sound
        sound_select = RandIntBetween(0, (llGetListLength(sound_name) - 1));
        llPlaySound(llList2String(sound_name, sound_select), random_volume);        
    }
    touch_end(integer total_number)
    {
        llOwnerSay("Stop Mooing!");
        state default;
    }
    state_exit()
    {
        llSetTimerEvent(0.0);    
    }
} 