//drinking script
float INTERVAL = 20.0;
string ANIMATION = "avatar_drink";
string anim0;
string anim1;

lookup()
{
    anim0 = llGetInventoryName(INVENTORY_ANIMATION,0);
    anim1 = llGetInventoryName(INVENTORY_ANIMATION,1);
    if ( anim0 != "" ) ANIMATION = anim0;
    if ( anim1 != "" ) ANIMATION = anim1;
}

default
{
    state_entry()
    {
        if (llGetAttached() != 0)
        { llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION); }
        else
        { llOwnerSay("Wear me. Do not rez on the ground."); }
        lookup();
    }

    on_rez(integer param) { llResetScript(); }
    
    changed(integer change)
    {
        if (change & CHANGED_INVENTORY) lookup();
    }

    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION)
        {
            if (anim1 != "") llStartAnimation(anim0);
            llSetTimerEvent(INTERVAL);
        }
    }
    
    timer()
    {
        llStartAnimation(ANIMATION);
        if (anim1 != "") llStartAnimation(anim0);
    }
}