//
list daySounds = ["bird", "bird_1", "bird_2", "birdfly", "forest", "nightengale", "sparrow"];
list nightSounds = [""];

list nightAmbient = [""];

default {
    state_entry() {
        llStopSound();
        llSetTimerEvent(2.0);
    }

    timer() {
        vector time = llGetSunDirection();
        list myList;
        float density = 0.9;

        if (time.z > 0.0) {
            myList = llListRandomize(daySounds, 1);
        } else {
            myList = llListRandomize(nightSounds, 1);
            density = 0.98;
            
            // Ambient nighttime sound
            if (llFrand(1.0) > 0.85) {
                llStopSound();
            } else {
                llLoopSound(llList2String(nightAmbient, 0), 1.0);
            }
        }
        
        if (llFrand(1.0) > density) {
            llTriggerSound(llList2String(myList, 0), 1.0);
        }
    }
}
