integer Private = 1;    // Change to 1 to prevent others riding.
vector Sitpos = <0.60,0,.55>;
vector SitrotV = <0,0,0>;
rotation Sitrot;
integer tt;
key oldagent;
key agent;
float forward_power = 14; //Power used to go forward (1 to 30)
float forward_normal = 20;
float crash_power_forward = 2;
float reverse_power = -3; //Power ued to go reverse (-1 to -30)
float turning_ratio = 0.25; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
integer turncount;
string Wheeldir = "WC";
string NewWheeldir = "WC";
string Wheelrot = "S";
string NewWheelrot = "S";
float Speed;
integer Gear = 1;
integer Run;
integer oldn;
string sit_message = "Ride"; //Sit message
string not_owner_message = "You are not the owner of this vehicle, but you can copy it and have your own to test in this sim."; //Not owner message
vector COLOR = <1.0,1.0,1.0>;
float ALPHA_ON = 0.10;
float ALPHA_OFF = 0.0;
//This forces an initial update.
integer visible = FALSE;
string TITLE="Drive!";   
string      DrivingAnim = "driving generic"; //Animation to play when owner sits

go_up()
{
    llSetStatus(STATUS_PHYSICS, FALSE);
    llSetRot(<0,0,0,0>);
    llSetStatus(STATUS_PHYSICS, TRUE);
}

setCamera(float degrees) {
rotation sitRot = llAxisAngle2Rot(<0, 0, 1>, degrees * PI);
llSetCameraEyeOffset(<-10, 0, 3> * sitRot);
llSetCameraAtOffset(<4, 0, 3> * sitRot);
llForceMouselook(FALSE);
}

setVehicle()
{
        llSetVehicleType(VEHICLE_TYPE_CAR);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.2);
        llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.80);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 0.10);
        llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 0.10);
        llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 3.0);
        llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 0.1);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_TIMESCALE, 0.1);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 0.1);
        llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <100.0, 2.0, 1000.0>);
        llSetVehicleVectorParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, <0.1, 0.1, 0.1>);
        llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.1);
        llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 5.0);
        llSetVehicleFloatParam(VEHICLE_BUOYANCY, 0.01 );
        llSetVehicleFloatParam( VEHICLE_BANKING_EFFICIENCY, -0.2 );
        llSetVehicleFloatParam( VEHICLE_BANKING_MIX, 1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_TIMESCALE, 1 );
}

Init()
{
    Run = 0;
    llSetVehicleType(VEHICLE_TYPE_NONE);
    llSetStatus(STATUS_PHYSICS, FALSE);
    Sound(0);
    show();
    
    vector rotv = llRot2Euler(llGetRot());
    rotation rot = llEuler2Rot(<0,0,rotv.z>);
    llSetRot(rot);
    
    Sitrot = llEuler2Rot(DEG_TO_RAD * SitrotV);
    
    llMessageLinked(LINK_ALL_OTHERS, 0, "S", NULL_KEY);     // wheels stop
    llMessageLinked(LINK_ALL_OTHERS, 0, "WC", NULL_KEY);     // wheels straight
}

Reset()
{
    Run = 0;
    vector rotv = llRot2Euler(llGetRot());
    rotation rot = llEuler2Rot(<0,0,rotv.z>);
    llSetRot(rot);
    llSetPos(llGetPos() + <0,0,0.5>);
//    Sitrot = llEuler2Rot(DEG_TO_RAD * SitrotV);
//    llSetVehicleType(VEHICLE_TYPE_NONE);
//    llMessageLinked(LINK_ALL_OTHERS, 0, "S", NULL_KEY);     // wheels stop
//    llMessageLinked(LINK_ALL_OTHERS, 0, "WC", NULL_KEY);     // wheels straight
}

integer LastSetMaterial = FALSE;
SetMaterial()
{
    // This causes a full update to be sent to ALL clients for each primitive that listens to this linked message. This should be called only ONCE!
    if(LastSetMaterial == FALSE)
    {
        LastSetMaterial = TRUE;
        llSetPrimitiveParams([PRIM_MATERIAL, PRIM_MATERIAL_GLASS]);
        llMessageLinked(LINK_ALL_OTHERS, 0, "SetMat", NULL_KEY);    // Tell daughter pims on ground to be glass
    }
}

Sound(integer n)
{
    if(n != oldn)
    {
        oldn = n;
        if(n == 2)
        {
            llStopSound();
            //llLoopSound("run",1);
        }
        else if(n == 1)
        {
            //Loop sound overwrites the old sound, do not need to schedule another full update for that.
            //llStopSound();
            llLoopSound("idle",1);
        }
        else
        {
             llStopSound();
        }
    }
}

show()
{
    //Schedules more sometimes unnecessary full updates, only fire when needed
    if(visible == FALSE)
    {
        visible = TRUE;
        //Only set if there is a title.
        if(TITLE != "")
        {
            llSetText(TITLE, COLOR,ALPHA_ON);   
        }     
        llSetAlpha(ALPHA_ON, ALL_SIDES);
    }
}
 
hide()
{
    //Same as in show().
    if(visible == TRUE)
    {
        visible = FALSE;
        if(TITLE != "")
        {
            llSetText("", COLOR,ALPHA_ON);
        }
        llSetAlpha(ALPHA_OFF, ALL_SIDES);
    }
}    

default
{
    state_entry()
    {
        Init();
        llSetSitText(sit_message);
        llSitTarget(Sitpos, Sitrot);
        setCamera(0);
    }

collision(integer collide1)
{
    //forward_power = 10; //Power used to go forward (1 to 30)
    //reverse_power = -3; //Power ued to go reverse (-1 to -30)
    //turning_ratio = 0.28; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
    //llSetText("collision",<1,1,1>,1);
    //    llSay(0,"collision");    
    //    llMessageLinked(LINK_SET, 0, "collide", NULL_KEY);
}

collision_start(integer collide)
{
    forward_power = crash_power_forward; //Power used to go forward (1 to 30)
    //reverse_power = -3; //Power ued to go reverse (-1 to -30)
    turning_ratio = 0.05; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
    //llSetText("collision_start",<1,1,1>,1);
    //    llSay(0,"collision_start"); 
   if (agent == llGetOwner()) { llMessageLinked(LINK_SET, 0, "collide", NULL_KEY);}
    llSetBuoyancy(0.001);
}

collision_end(integer collide)
{
    //    llSay(0,"collision_end");
    forward_power = forward_normal; //Power used to go forward (1 to 30)
    //reverse_power = -3; //Power ued to go reverse (-1 to -30)
    turning_ratio = 0.25; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
    //llSetText("collision_start",<1,1,1>,1);
    //    llSay(0,"collision_end-2"); 
    llSetBuoyancy(0.0);
}    

    //land_collision(integer collide4)
    //{
    //forward_power = 10; //Power used to go forward (1 to 30)
    //reverse_power = -3; //Power ued to go reverse (-1 to -30)
    //turning_ratio = 0.28; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
    //llSetText("land_collision",<1,1,1>,1);
    //}

    //land_collision_start(integer collide5)
    //{
    //forward_power = 10; //Power used to go forward (1 to 30)
    //reverse_power = -3; //Power ued to go reverse (-1 to -30)
    //turning_ratio = 0.28; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
    //llSetText("land_collision_start",<1,1,1>,1);
    //}

    //land_collision_end(integer collide6)
    //{
    //forward_power = 1; //Power used to go forward (1 to 30)
    //reverse_power = -1; //Power ued to go reverse (-1 to -30)
    //turning_ratio = 10; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
    //llSetText("land_collision_end",<1,1,1>,1);
    //}

   on_rez(integer rn)
    {
        llResetScript();
        llSetPos(llGetPos() + <0,0,0.5>);
    }

    link_message(integer sender, integer num, string message, key id)
    {
    if(message=="reset")
        {
        Reset();
        llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
        llMessageLinked(LINK_SET, 0, "collide", NULL_KEY);
        }
    }

        
            
    changed(integer change)
    {
        if ((change & CHANGED_LINK) == CHANGED_LINK)
        {
            agent = llAvatarOnSitTarget();
            if (agent != NULL_KEY)
            {                
                if( (agent != llGetOwner()))
                {
                    llSay(0, not_owner_message);
                    llUnSit(agent);
                    llPlaySound("car alarm",1.0);
                    llMessageLinked(LINK_SET, 0, "shift", "8");
                    llPushObject(agent, <0,0,50>, ZERO_VECTOR, FALSE);
                }
                else
                {
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    llSleep(.4);
                    oldagent = agent;
                    setVehicle();
                    SetMaterial();
                    llSetTimerEvent(0.3);
                    llMessageLinked(LINK_SET, 0, "shift", "2");
                    llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
                    llMessageLinked(LINK_SET, 0, "headlight", "0");

                    llRequestPermissions(agent, PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS);

                    Sound(1);
                    hide();
                    Run = 1;
                }
            }
            else
            {
                Run = 0;
                llReleaseControls();
                llStopAnimation(DrivingAnim);
                Init();
                
                llMessageLinked(LINK_SET, 0, "shift", "8");                
                llSetPos(llGetPos() + <0,0,0.5>);
                llMessageLinked(LINK_ALL_OTHERS, 0, "S", NULL_KEY);
                Sound(0);
                //Less efficent than going through Sound()
                //llStopSound();
            }
        }
    }
    
    run_time_permissions(integer perm)
    {
        if (perm)
        {
            forward_power = forward_normal; //Power used to go forward (1 to 30)
            reverse_power = -3; //Power ued to go reverse (-1 to -30)
            turning_ratio = 0.28; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
            Gear = 2;
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT | CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
            llPlaySound("start",1.0);
            llMessageLinked(LINK_SET, 0, "shift", "2");
            llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "headlight", "0");
            llSetPos(llGetPos() + <0,0,0.5>);
            llStartAnimation(DrivingAnim);
            llWhisper(0,"Hit M for mouselook, page up and down for shifting, if you flip standing will flip car back on its wheels. type /2 listcolors to see available colors and /2 color <name> to change colors.");
        }
    }
    
    control(key id, integer level, integer edge)
    {
        if(Run == 0)
        {
            return;
        }
        integer reverse=1;
        vector angular_motor;
        
        //get current speed
        vector vel = llGetVel();
        Speed = llVecMag(vel);
        //llOwnerSay((string)Speed);
        //car controls
        
        if ((level & edge & CONTROL_UP) || ((Gear >= 7) && (level & CONTROL_UP)))
        {
            Gear=Gear+1;
            if(Gear == 1){ 
                          llMessageLinked(LINK_SET, 0, "screech", NULL_KEY);
                          llMessageLinked(LINK_SET, 0, "shift", "1");

            llLoopSound("gear8",1);
                          llSay(0,"Burn Out");
                         }
            if(Gear == 2) {
                          llSay(0,"1st Gear");
            llLoopSound("gear1",1);
                          llMessageLinked(LINK_SET, 0, "shift", "2");
                          }
            if(Gear == 3) {
                          llSay(0,"2nd Gear");
            llLoopSound("gear2",1);
                          llMessageLinked(LINK_SET, 0, "shift", "3");
                          }                          
            if(Gear == 4) {
                          llSay(0,"3rd Gear");
            llLoopSound("gear3",1);
                          llMessageLinked(LINK_SET, 0, "shift", "4");
                          }                                
            if(Gear == 5) {
                          llSay(0,"4th Gear");
            llLoopSound("gear4",1);
                          llMessageLinked(LINK_SET, 0, "shift", "5");
                          }                                
            if(Gear == 6) {
                          llSay(0,"5th Gear");
            llLoopSound("gear5",1);
                          llMessageLinked(LINK_SET, 0, "shift", "6");
                          }      
            if(Gear == 7) {
                          llSay(0,"TURBO...!!!");
            llLoopSound("gear6",1);
                          llMessageLinked(LINK_SET, 0, "shift", "7");
                          }                                
            if (Gear < 1) Gear = 1;
            if (Gear > 7) Gear = 7;
        }
        
        if ((level & edge & CONTROL_DOWN) || ((Gear >= 7) && (level & CONTROL_DOWN)))
        {
            Gear=Gear-1;
            if(Gear == 1){ 
                          llMessageLinked(LINK_SET, 0, "screech", NULL_KEY);
                          llMessageLinked(LINK_SET, 0, "shift", "1");
                          llSay(0,"Burn Out");
            llLoopSound("gear8",1);
                         }
            if(Gear == 2) {
                          llSay(0,"1st Gear");
            llLoopSound("gear1",1);
                          llMessageLinked(LINK_SET, 0, "shift", "2");
                          }
            if(Gear == 3) {
                          llSay(0,"2nd Gear");
            llLoopSound("gear2",1);
                          llMessageLinked(LINK_SET, 0, "shift", "3");
                          }                          
            if(Gear == 4) {
                          llSay(0,"3rd Gear");
            llLoopSound("gear3",1);
                          llMessageLinked(LINK_SET, 0, "shift", "4");
                          }                                
            if(Gear == 5) {
                          llSay(0,"4th Gear");
            llLoopSound("gear4",1);
                          llMessageLinked(LINK_SET, 0, "shift", "5");
                          }                                
            if(Gear == 6) {
                          llSay(0,"5th Gear");
            llLoopSound("gear5",1);
                          llMessageLinked(LINK_SET, 0, "shift", "6");
                          }      
            if(Gear == 7) {
                          llSay(0,"TURBO...!!!");
            llLoopSound("gear6",1);
                          llMessageLinked(LINK_SET, 0, "shift", "7");
                          }                                
            if (Gear < 1) Gear = 1;
            if (Gear > 7) Gear = 7;
        }
        
        if(level & CONTROL_FWD)

        {
            turning_ratio = 0.3;
            if(Gear == 1) {
            llMessageLinked(LINK_SET, 0, "letsburn", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "letsscreech", NULL_KEY);
            llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <(Gear*forward_power),0,0>);
                          }
            if(Gear == 2) {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*forward_power,0,0>);
                          }
            if(Gear == 3) {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*forward_power,0,0>);   
                          }
            if(Gear == 4) {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*forward_power,0,0>);  
                          }                                              
            if(Gear == 5) {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*forward_power,0,0>);
                          }
            if(Gear == 6) {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*forward_power,0,0>);
                          }
            if(Gear == 7) {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*(forward_power),0,0>);
          llMessageLinked(LINK_SET, 0, "pipeflame", NULL_KEY);
                          }
            reverse=1;
            NewWheelrot = "F";
        }

        if(level & CONTROL_BACK)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*reverse_power,0,0>);
            turning_ratio = -0.3;
            reverse = -1;
            NewWheelrot = "R";
        }

        if(level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT))
        {
//          angular_motor.z -= Speed / (turning_ratio*Gear) * reverse;
            angular_motor.z -= Speed / (turning_ratio*Gear);
            NewWheeldir = "WR";
            turncount = 10;
        }
                        
        if(level & (CONTROL_LEFT|CONTROL_ROT_LEFT))
        {
//          angular_motor.z += Speed / (turning_ratio*Gear) * reverse;
            angular_motor.z += Speed / (turning_ratio*Gear);
            NewWheeldir = "WL";
            turncount = 10;
        }

       llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, angular_motor);
        if(turncount > 0)
        {
            turncount--;
        }
        if(turncount == 1)
        {
            NewWheeldir = "WC";
        }
        if(Wheeldir != NewWheeldir){
            Wheeldir = NewWheeldir;
            llMessageLinked(LINK_ALL_OTHERS, 0, Wheeldir, NULL_KEY);
       }
        if(Wheelrot != NewWheelrot){
            Wheelrot = NewWheelrot;
            llMessageLinked(LINK_ALL_OTHERS, 0, Wheelrot, NULL_KEY);
        }
    } //end control       

    timer(){
        if(Run == 1){

            vector vel = llGetVel();
            Speed = llVecMag(vel);

            if(Speed > 2.0)
            {
 //           llOwnerSay((string)Speed);
               Sound(2);
            }

            else if(Speed > 0.0)
            {
                llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <1.0, 2.0, 1000.0>);
                llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0,0,0>);
                llMessageLinked(LINK_ALL_OTHERS, 0, "S", NULL_KEY);
                Sound(1);
                Wheelrot = "S";
            }
                llSetTimerEvent(0.3);          // If restarted timer() appears to keep working  
            }
            else
            {
                llSetTimerEvent(0.0);
        }
    }
    
} //end default