list buttons = ["Expo 4", "Expo 5", "Cancel", "Expo 1", "Expo 2", "Expo 3"];
string dialogInfo = "\nSponsor Expo booths are located on Expo Zones 1-5.";
 
key ToucherID;
integer dialogChannel;
integer listenHandle;
 
default
{
    state_entry()
    {
        dialogChannel = -1 - (integer)("0x" + llGetSubString( (string)llGetKey(), -7, -1) );
    }
 
    touch_start(integer num_detected)
    {
        ToucherID = llDetectedKey(0);
        llListenRemove(listenHandle);
        listenHandle = llListen(dialogChannel, "", ToucherID, "");
        llDialog(ToucherID, dialogInfo, buttons, dialogChannel);
        llSetTimerEvent(60.0); // Here we set a time limit for responses
    }
 
    listen(integer channel, string name, key id, string message)
    {
        llListenRemove(listenHandle);
        //  stop timer since the menu was clicked
        llSetTimerEvent(0);
        if (message == "Expo 1")
        {
            osTeleportAgent(ToucherID, "Expo Zone 1", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Expo 2")
        {
            osTeleportAgent(ToucherID, "Expo Zone 2", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Expo 3")
        {
            osTeleportAgent(ToucherID, "Expo Zone 3", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Expo 4")
        {
            osTeleportAgent(ToucherID, "Expo Zone 4", <128,128,30>, <1,1,1>); 
        } 
        else if (message == "Expo 5")
        {
            osTeleportAgent(ToucherID, "Expo Zone 5", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Cancel")
        {
            llWhisper(0, "Ok, please make another choice."); 
        } 
        else
        {
            // do any other action here
        }
    }
 
    timer()
    {
    //  stop timer
        llSetTimerEvent(0);
 
        llListenRemove(listenHandle);
        llWhisper(0, "Sorry, you took too long to make a choice.");
    }
}