list buttons = ["Keynote 3", "Keynote 4", "Cancel", "Keynote 1", "Keynote 2"];
string dialogInfo = "\nCheck your group membership to see which OSCC Zone group you have been assigned to, and teleport to the corresponding Keynote region. (Example: OSCC Zone 1 = Teleport to Keynote 1)";
 
key ToucherID;
integer dialogChannel;
integer listenHandle;
 
default
{
    state_entry()
    {
        dialogChannel = -1 - (integer)("0x" + llGetSubString( (string)llGetKey(), -7, -1) );
    }
 
    touch_start(integer num_detected)
    {
        ToucherID = llDetectedKey(0);
        llListenRemove(listenHandle);
        listenHandle = llListen(dialogChannel, "", ToucherID, "");
        llDialog(ToucherID, dialogInfo, buttons, dialogChannel);
        llSetTimerEvent(60.0); // Here we set a time limit for responses
    }
 
    listen(integer channel, string name, key id, string message)
    {
        llListenRemove(listenHandle);
        //  stop timer since the menu was clicked
        llSetTimerEvent(0);
        if (message == "Keynote 1")
        {
            osTeleportAgent(ToucherID, "Keynote 1", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Keynote 2")
        {
            osTeleportAgent(ToucherID, "Keynote 2", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Keynote 3")
        {
             osTeleportAgent(ToucherID, "Keynote 3", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Keynote 4")
        {
             osTeleportAgent(ToucherID, "Keynote 4", <128,128,30>, <1,1,1>); 
        }
        else if (message == "Cancel")
        {
            llWhisper(0, "Ok, please make another choice."); 
        }        
        else
        {
            // do any other action here
        }
    }
 
    timer()
    {
    //  stop timer
        llSetTimerEvent(0);
 
        llListenRemove(listenHandle);
        llWhisper(0, "Sorry, you took too long to make a choice.");
    }
}