string tpRegionName = "Education Track";
string tpRegionDesc = "Breakout Zone 4 - Research & Education";

//Nothing to edit below this line!

list buttons = ["YES", "NO"];
 
key ToucherID;
integer dialogChannel;
integer listenHandle;
 
default
{
    state_entry()
    {
        dialogChannel = -1 - (integer)("0x" + llGetSubString( (string)llGetKey(), -7, -1) );
    }
 
    touch_start(integer num_detected)
    {
        ToucherID = llDetectedKey(0);
        llListenRemove(listenHandle);
        listenHandle = llListen(dialogChannel, "", ToucherID, "");
        llDialog(ToucherID, "\nAre you sure you want to teleport to " + tpRegionDesc + "?", buttons, dialogChannel);
        llSetTimerEvent(60.0); // Here we set a time limit for responses
    }
 
    listen(integer channel, string name, key id, string message)
    {
        if (message == "YES")
        {
            osTeleportAgent(ToucherID, tpRegionName, <128,128,30>, <1,1,1>); 
        }
 
        llListenRemove(listenHandle);
        //  stop timer since the menu was clicked
        llSetTimerEvent(0);
 
        if (message == "NO")
        {
            llWhisper(0, "Ok, please make another choice.");
        }
        
        else
        {
            // do any other action here
        }
    }
 
    timer()
    {
    //  stop timer
        llSetTimerEvent(0);
 
        llListenRemove(listenHandle);
        llWhisper(0, "Sorry, you took too long to make a choice.");
    }
}