// HoverText Clock Script
// By Ben Linden
//
// Drop on an object to make it display the PST time.
integer playChime=0;
integer savedHour;
integer savedMinutes;
integer savedSeconds;
string smin; // Represents minutes
string sseconds; //Represens seconds

default
{
    state_entry()
    {
        llListen(0,"",llGetOwner(),"");        
        llSetTimerEvent(1.0);  // call a timer event 
        savedHour=0;
    }
    
    listen(integer channel, string name, key id, string m)
    {
        if (m=="chime")
        {
            if (playChime==1)
            {
                playChime=0;
                llSay(0,"Hour Chime Sound Effect ON");
            }
            else   
            {
                playChime=1;
                llSay(0,"Hour Chime Sound Effect OFF");
            }
        }
    }    
    
    timer()
    {
        string ampm;
       integer seconds =  llFloor(llGetWallclock());
       integer min = llFloor(seconds/60);
       seconds = seconds - (min*60);
       integer hour = llFloor(min/60);
       min = min - (hour*60);
       ampm="am";
        if(hour > 12)
        {
            hour = hour - 12;
            ampm="pm";
        } // if the hours are greater than 12, convert to 12 hour time

//==================================================            
if (hour!=savedHour)
{
    savedHour=hour;
    if(playChime==0)llPlaySound("chimes_01",1.0);
}                
//if (seconds!=savedSeconds)
//{
//    savedSeconds=seconds;
//    llPlaySound("tick",.5);
//}                
//if (min!=savedMinutes)
//{
//    savedMinutes=min;
//    llPlaySound("tock",1.0);
//}                
//==================================================            
       string shour = (string)hour; //convert the number into a string
       if(min < 10) {smin = "0"+(string)min;} // if less than 10 minutes, put a 0 in the minute string
       else { smin = (string)min;} 
       if(seconds < 10) { sseconds = "0"+(string)seconds;} // if less than 10 sec, put a 0 in the second string
       else {sseconds = (string)seconds;}
       
       
//       string time = shour + ":" + smin + ":" + sseconds + ampm; // build the seperate strings into a complete string, with colons
       string time = shour + ":" + smin + ":" + ampm; // build the seperate strings into a complete string, with colons
       
       // llSetText is a function that displays a string over the object.
    //   llSetText(time, ZERO_VECTOR, 1.0); //Display the string in solid black.
   // llSetText(time,<0,0,1>,1);


    }

}
