integer listenHandle;
key toucher;
string name;

integer touchable = TRUE;

default
{
    state_entry()
    {
        llOwnerSay("Toucan Script running."); 
    }
    
    touch_start(integer numDetected)
    {
        if(touchable)
        {
            touchable= FALSE;
            toucher = llDetectedKey(0);
            name = llKey2Name(toucher);
        
            listenHandle = llListen(PUBLIC_CHANNEL, "", toucher, "");
        
            llInstantMessage(toucher, "Hi there, " + name   
            + ", would you like to have a chat?\n"
            + " Press Enter to show your chat bar, then type a message and press Enter to send.");

            llSetTimerEvent(15);
        }
    }
    
    listen(integer channel, string name, key id, string msg)
    {
        string sub = llGetSubString(msg, -1, -1);
        
        if(sub != "." && sub != "?" && sub != "!")
        {
            msg = msg + ".";
        }
        
        llInstantMessage(toucher, "Wow, " + name 
            + ", that's really interesting. More people ought to know about " 
            + msg 
            + "\nIt was nice having this long conversation with you. \nTo hide your chat bar when you're done chatting just press Escape on your keyboard.\nIf you ever want your chat to stay up on the screen without fading, click the Local Chat button. \nHave a nice day and good luck!");

        llListenRemove(listenHandle);
        
        touchable = TRUE;
        llSetTimerEvent(0);
    }   
    
    timer()
    {
        llInstantMessage(toucher, "Wow, " + name 
            + ", you type really slow! Have a good day!");
        llListenRemove(listenHandle);
        touchable = TRUE;
        llSetTimerEvent(0);
    }
}