//************************************************************************************
//
// Laser Pointer for Troy McLuhan's Slide Presenter
// Copyright (C) 2008 by Rob Knop (Prospero Frobozz in SL)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You can get a copy of the GNU General Public License at 
// http://www.gnu.org/licenses/gpl.txt
// or by writing to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// Rob can be reached by email at rknop@pobox.com
//
//************************************************************************************
//
// Laser Pointer v1.1


vector color=<1., 0., 0.>;
integer on;

default
{
    on_rez(integer start_param)
    {
        llResetScript();
    }
    
    state_entry()
    {
        on = 0;
        llSetPrimitiveParams([ PRIM_COLOR, ALL_SIDES, <1., 1., 1.>, 0.,
                                PRIM_GLOW, ALL_SIDES, 0.]);
    }

    link_message(integer sender, integer num, string str, key id)
    {
        if (num == 0)
        {
            llSetPrimitiveParams([ PRIM_COLOR, ALL_SIDES, <1., 1., 1.>, 0.,
                                    PRIM_GLOW, ALL_SIDES, 0.] );
            on = 0;
        }
        else if (num == 1)
        {
            llSetPrimitiveParams([ PRIM_COLOR, ALL_SIDES, color, 1.,
                                    PRIM_GLOW, ALL_SIDES, 0.4] );
            on = 1;
        }
        if (num == 2)
        {
            vector v = (vector)str;
            //llSetPrimitiveParams([PRIM_POSITION, v, PRIM_ROTATION, llEuler2Rot(<PI/2., 0, PI>)]);
            llSetPrimitiveParams([PRIM_POSITION, v]);                                
                                
        }
        if (num == 3)
        {
            color = (vector)str;
            if (on)
            {
                llSay(0, "Setting laser color to "+(string)color);
                llSetPrimitiveParams([ PRIM_COLOR, ALL_SIDES, color, 1.,
                                        PRIM_GLOW, ALL_SIDES, 0.4] );
            }
        }
        
    }
}
