/*Chair script - sets sit target, forces mouselook, sets a camera position in 
    case user leaves mouselook.
*/
/**

setSitTarget()
{
    vector eul = <0.0, 0.0, -90.0>;
    eul *= DEG_TO_RAD;
                
    llSitTarget(<-0.1, -0.3, 0.46>, llEuler2Rot(eul));
}
    


default
{
    state_entry()
    {
        setSitTarget();
        
        //llForceMouselook(TRUE);
  
    }
}
**/
default     //example with work-around for llSetTarget rot bug
{           //place in any prim large enough to sit on at any angle
            //click once to choose a place to sit, a second time to sit there
    
    state_entry()
    {
        llResetScript();
    }
    
    touch_start(integer num)
    {
        vector pos=llDetectedTouchPos(0);       //use touch to set sit target
        vector lft=llDetectedTouchBinormal(0);  //use normals to rotate avatar to
        vector up=llDetectedTouchNormal(0);     //sit upright
        rotation rot=llAxes2Rot(lft%up,lft,up)/llGetRot();  //rotate avatar to stand there
        vector siz=llGetAgentSize(llDetectedKey(0));
        pos += 0.27*siz.z*up;       //this places MY avatars feet close to the surface
        pos = (pos-llGetPos())/llGetRot();  //llSetTarget expects local co-ordinates
        if (rot!=ZERO_ROTATION) pos -=<0,0,0.4>;  //here is the work around
        llSitTarget(pos,rot);
        llSetClickAction(CLICK_ACTION_SIT);   //switch to sit for second click
        llSetCameraAtOffset(<2.0, 0.01, 0.5>);
        llSetCameraEyeOffset(<2.0, -2.5, 1.7>);
    }
    changed(integer change)
    {
        if (llAvatarOnSitTarget()==NULL_KEY)    //if they unsit,
            llSetClickAction(CLICK_ACTION_TOUCH);   //go back to click mode
    }
}