float   volume    = 0.45; //The volume used to play the sounds
float   frequency = 5.0;  //Percentage of the time to play a random sound
integer numSounds = 5;

playRandomSound()
{
    integer RandomNumber;
    
    //Generate a random number between 1 and 5
    RandomNumber = (integer)llFrand(numSounds) + 1;
    
    //Play a Cow Sound at the configured volume
    llPlaySound("seagulls #" + (string)RandomNumber, volume);    
}

default
{
    state_entry()
    {
        //Start the Timer
        llSetTimerEvent(1);
    }
    
    on_rez(integer start_param)
    {
        //Reset the Script when we rez the object from inventory
        llResetScript();
    }

    touch_start(integer total_number)
    {
        //Play a random sound for someone touching the object
        playRandomSound();
    }
    
    timer()
    {
        //Generate random number between 0 and 1, compare to frequency
        if (llFrand(1) < (frequency/100))
        {
            playRandomSound();
        }
    }
}
