/* INFORMATION SELLING SCRIPT 
    
    last edited - 12-19-2012
*/

/*This script belongs to objects with information to sell
   The object has one channel solely for whispering on - to get the attention of other scripts
   The object generates a random channel for listening on when it has the attention of a script.
   The object responds with information if it gets the go ahead.
*/

//the channel upon which the script whispers when it is touched.
integer whisperChannel = -90909;
 
//the channel generated when touched to listen to HUD scripts.
integer randomChannel = -9013;

//the handle for the listen.
integer listenHandle;

//the key of the http request.
key requestKey;

//the information that the tree has can sell: its height, its diameter, and its species
//note that these do not need to be any specific length, as they are instant messaged to the user
string height = "m"; //in meters (not assigned a real value yet.)
string diameter = "cm"; //same deal
float height_float;
float diameter_float;


//This is a big long list of possible tree species.
//a few will be chosen based on what trevor makes
//just keep all the names here and uncomment the one you want.

//string species = "Hieronyma alchorneoides";
//string species = "Carapa guianensis";
//string species = "Qualea paraensis";
//string species = "Ocotea guianensis";
//string species = "Jacaranda copaia";
string species = "Virola koschnyi";
//string species = "Vochysia ferruginea";
//string species = "Tabebuia insignis";
//string species = "Pentaclethra macroloba";
//string species = "Ceiba pentandra";

//the avatar who touches the tree
key toucher;

//not touchable after being touched until it is reset.
integer touchable = TRUE;

//url of the page for writing to the database
string write = "http://sciethics.net/species_write.php";


//returns a random integer between min and max
//CAN RETURN MIN OR MAX (or anything between, of course)
/*integer random_integer( integer min, integer max )
{
     return min + (integer)( llFrand( max - min + 1 ) );
}*/

//given floats min and max gives a float in that range
/*float random_float(float min, float max)
{
    return min + (llFrand( max - min + 1 ));
}*/

//truncates a float and returns a string
string fixedPrecision(float input, integer precision)
{
    if((precision = (precision - 7 - (precision < 1))) & 0x80000000)
        return llGetSubString((string)input, 0, precision);
    return (string)input;
}
    


updateDB(key avatarKey)
{
    string body = ""; 
    
        //question mark denotes the beginning of the query string in the url
        //ampersand separates the field/value pairs.
    string URL = write + "?" + "key=" + (string)avatarKey + "&" + "species=" + species;

    list parameters = [HTTP_METHOD, "GET"];
    requestKey = llHTTPRequest(URL, parameters, body);
}

//fakes resetting the script.
//more efficient (tested)
reset()
{
    llSetTimerEvent(0.0); 
    llListenRemove(listenHandle);   
    touchable = TRUE;
    key toucher = NULL_KEY;
}


default
{
    state_entry()
    {
        llOwnerSay("Script for tree of species " + species + " running.");
        
        
       /* height_float = random_float(16.0, 40.0);
        diameter_float = random_float(0.5, 3.0);
        */
        
        height_float = 36.1;
        diameter_float = 225.3;
        height = fixedPrecision(height_float, 2) + height;
        diameter = fixedPrecision(diameter_float, 2) + diameter;
        
        //llOwnerSay("height = " + height);
        //llOwnerSay("diameter = " + diameter);
        
        
    }

    touch_start(integer numDetected)
    {
        if(touchable)
        {
            touchable = FALSE;
            toucher = llDetectedKey(0);
         //   randomChannel = random_integer(-9999,-1000);
            
            //llOwnerSay((string)randomChannel);
            listenHandle = llListen(randomChannel, "", "", "");            
            llWhisper(whisperChannel, (string)toucher + (string)randomChannel );
            llSetTimerEvent(10.0);
        }
        else
        {
            llInstantMessage(llDetectedKey(0), "Sorry, busy right now.");
        }
    }

    timer()
    {
        reset();
    }

    listen(integer channel, string name, key id, string msg)
    {
        if(channel == randomChannel)
        {
            llSetTimerEvent(0.0); //just in case.

            if(msg == "0")
            {
                //llInstantMessage(toucher, "Understood. Good luck in your travels.");
            }
            else if (msg == "1")
            {
                llSleep(2.0);
                llInstantMessage(toucher, "\nDiameter = " + diameter);
            }
            else if (msg == "2")
            {
                //GIVE INVENTORY TREE SAMPLE
                //llGiveInventory(toucher, "species"); //species is the name of the notecard
                                                     //containing the tree's species
                                                
                llSleep(1.0);
                llInstantMessage(toucher, "\nDiameter = " + diameter
                            //+ "\nTree species = " + species);
                            + "\nSample collected.");
                updateDB(toucher);
            }
            else if (msg == "3")
            {
                //GIVE INVENTORY TREE SAMPLE
                //llGiveInventory(toucher, "species"); //species is the name of the notecard
                                                     //containing the tree's species
                llSleep(1.0);
                llInstantMessage(toucher, "\nDiameter = " + diameter
                            //+ "\nTree species = " + species    
                            + "\nHeight = " + height
                            + "\nSample collected.");
                updateDB(toucher);
            }
            
            reset();          
        }
    }    
} 