///////////////////////////////////////////////////////////////////////////////////
///////
///////
///////
///////            screen display
///////            initially created by Anthony Bundy, i3D Inc.
///////             
///////             Date Jan 12, 2008
///////             
///////             This script listens on a certain channel for a message
///////             SETTEXTURE::(key) where (key) is the texture key to show on its display face
///////             
///////             Copyright (C) <2008>  <i3D Inc.>
///////             Contact: team@i3dnow.com
///////             
///////                 This program is free software: you can redistribute it and/or modify
///////                 it under the terms of the GNU General Public License as published by
///////                 the Free Software Foundation, either version 3 of the License, or
///////                 (at your option) any later version.
///////             
///////                 This program is distributed in the hope that it will be useful,
///////                 but WITHOUT ANY WARRANTY; without even the implied warranty of
///////                 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
///////                 GNU General Public License for more details.
///////             
///////                 You should have received a copy of the GNU General Public License
///////                 along with this program.  If not, see <http://www.gnu.org/licenses/>.
///////                 
///////                 Contact: team@i3dnow.com
///////                 
///////              
//////////////////////////////////////////////////////////////////////////////////////    

// Inputs

// Output

// Chat Channels used
    integer debugChannel = DEBUG_CHANNEL;
                         
    integer chatOffset = -2014101600;        // chat channel the display should listen to.
    integer chat2Display;

// Link Channels used
    integer link2All = -4873920;

// Global declarations
    integer debug = FALSE;                // for debugging
    integer myListener;
    list myMessage;
    integer currentChannel = 0;
    integer channelButtonLinkNum;
    key channelButtonTexture = "a9e3288c-1d2f-47fb-bb03-ffa02a52d294";
    string URLPreviewTexture = "URL";
    string ClickToPlayMediaTexture = "Click to play Media";

    key slide; // texture key for an X indicating there is no slide for that spot

    integer displayFace = 2;
    // integer displayFace = 2;
    
    list displayPrims = ["preview 1",0, "preview 2",0, "preview 3",0, "preview 4",0];
    list screenRatios = [1.7777777777777777777777777777777, 1.3333333333333333333333333333333, 1];
    integer currentRatio = 0;
    integer MEDIA = FALSE;
    
    list users = [];


//DEFAULT STATE//
default 
{
    state_entry() 
    {
        chat2Display = chatOffset+currentChannel;
        llListenRemove(myListener);
        myListener = llListen(chat2Display, "", NULL_KEY, "");
        integer tPrims = llGetNumberOfPrims();
        
        //Find the preload prims and save their link numbers
        if(tPrims > 1){
            integer i = 1;
            for(i;i<=tPrims;i++){
                integer tFound = llListFindList(displayPrims, [llGetLinkName(i)]); 
                if(tFound > -1){
                   
                    displayPrims = llListReplaceList(displayPrims,[i],tFound +1, tFound +1);
                }
            }
        }
        
    }
    
    listen(integer channel, string name, key id, string message) 
    {
        //Moderator HUD Commands
        if(llSubStringIndex(name, "Avacon Presenter Mod Hud") != -1){

            //Retrieving the list with of presenters and their activity status on this presentation board
            if(llSubStringIndex(message, "GIVE LIST") > -1){
                llRegionSayTo(id, chatOffset, llList2CSV(users));        
            
            //Adding a new Presenter    
            }else if(llSubStringIndex(message, "ADD NEW::") > -1){
                list tList = llCSV2List(llDeleteSubString(message, 0, llStringLength("ADD NEW::") - 1));
                users = users + tList;
                llRegionSayTo(id, chatOffset, llList2CSV(users));        
             
            //Change Status of presenter   
            }else if(llSubStringIndex(message, "CHANGE STATUS::") > -1){
                list tList = llCSV2List(llDeleteSubString(message, 0, llStringLength("CHANGE STATUS::") - 1));
                integer tFound = llListFindList(users, [llList2String(tList,0)]);
                if(tFound != -1){
                    users = llListReplaceList(users, tList, tFound, tFound +2);
                    llRegionSayTo(id, chatOffset, llList2CSV(users));
                
                }else{
                    llRegionSayTo(llGetOwnerKey(id), 0, "The User you are trying to change is not listed on this board, your screen will be reloaded");
                    llRegionSayTo(id, chatOffset, llList2CSV(users));
                }        
            
            //Remove a presenter
            }else if(llSubStringIndex(message, "REMOVE::") > -1){
                list tList = llCSV2List(llDeleteSubString(message, 0, llStringLength("REMOVE::") - 1));
                integer tFound = llListFindList(users, tList);
                if(tFound != -1){
                    users = llDeleteSubList(users, tFound, tFound + 2);
                }                 
                llRegionSayTo(id, chatOffset, llList2CSV(users));
    
            }
        
        //Presenter Commands
        }else{ 
            
            //Check if the presenter is in the permitted list
            integer tFound = llListFindList(users, llGetOwnerKey(id));
            if(tFound != -1){
                tFound = llList2Integer(users, tFound + 2);
                if(tFound){

                    if (llSubStringIndex(message, "SETTEXTURE::") > -1) 
                    {
                        // message is to set the texture key, -1 is for 0 based indexing on the characters
                        list tList = llCSV2List(llDeleteSubString(message, 0, llStringLength("SETTEXTURE::") - 1));
            
            
                        if(debug) llOwnerSay("slide: " + llList2CSV(tList));
                        if (llGetListLength(tList) > 0) 
                        {
                
                            ////PREVIEW 1 & 2
                            if(debug)llOwnerSay((string)osIsUUID(llList2Key(tList,0)));
                            if(osIsUUID(llList2Key(tList,0))){
                    
                                llSetLinkTexture(llList2Integer(displayPrims,1),llList2Key(tList,0), ALL_SIDES);
                            }else{
                    
                                llSetLinkTexture(llList2Integer(displayPrims,1), URLPreviewTexture, ALL_SIDES);                   
                            }
                 
                            if(osIsUUID(llList2Key(tList,1))){
                                llSetLinkTexture(llList2Integer(displayPrims,3),llList2Key(tList,1), ALL_SIDES);
                            }else{
                                llSetLinkTexture(llList2Integer(displayPrims,3), URLPreviewTexture, ALL_SIDES);                   
                            }   
                
                            /////////MAIN DISPLAY////////////
                            if(osIsUUID(llList2Key(tList,2))){
                    
                                llSetTexture(llList2Key(tList,2), displayFace);
                                if(MEDIA){
                                    MEDIA = FALSE;
                                    llClearPrimMedia(displayFace);
                                }
                            }else{
                                llSetTexture(ClickToPlayMediaTexture, displayFace);
                    

                                integer tReturn = llSetPrimMediaParams(2, [PRIM_MEDIA_CONTROLS, PRIM_MEDIA_CONTROLS_MINI, 
                                            PRIM_MEDIA_CURRENT_URL, llList2String(tList, 2),
                                            PRIM_MEDIA_HOME_URL, llList2String(tList, 2),
                                            PRIM_MEDIA_AUTO_LOOP, FALSE,
                                            PRIM_MEDIA_AUTO_PLAY , TRUE,
                                            PRIM_MEDIA_AUTO_SCALE, TRUE,
                                            PRIM_MEDIA_AUTO_ZOOM, TRUE,
                                            PRIM_MEDIA_PERMS_INTERACT,PRIM_MEDIA_PERM_ANYONE,
                                            PRIM_MEDIA_PERMS_CONTROL, PRIM_MEDIA_PERM_GROUP]);
                    
                                MEDIA = TRUE;
                                if(debug) llOwnerSay("media flag " + (string)tReturn);
                
                            }
                
                            ////PREVIEW 3 & 4
                            if(osIsUUID(llList2Key(tList,3))){
                                llSetLinkTexture(llList2Integer(displayPrims,5),llList2Key(tList,3), ALL_SIDES);
                            }else{
                                llSetLinkTexture(llList2Integer(displayPrims,5), URLPreviewTexture, ALL_SIDES);                   
                            }
                 
                            if(osIsUUID(llList2Key(tList,4))){
                                llSetLinkTexture(llList2Integer(displayPrims,7),llList2Key(tList,4), ALL_SIDES);
                            }else{
                                llSetLinkTexture(llList2Integer(displayPrims,7), URLPreviewTexture, ALL_SIDES);                   
                            }   
                
                        }
                    }else if(llSubStringIndex(message, "RESIZE") > -1){
                        currentRatio++;
                        if(currentRatio >= llGetListLength(screenRatios)){
                            currentRatio = 0;
                        }
                        vector tSize = llGetScale();
            
                        float newY = tSize.z * llList2Float(screenRatios, currentRatio);
            
                        llSetScale(<tSize.x, newY, tSize.z>);
                        //llOwnerSay((string)llGetScale());
                        //llOwnerSay((string)(newY/tSize.z));         
            
                    }
                }else{
                    llRegionSayTo(llGetOwnerKey(id), 0, "You are not activated to use the Presentation screen, talk to a moderator.");
                }
            }else{
                llRegionSayTo(llGetOwnerKey(id), 0, "You are not activated to use the Presentation screen, talk to a moderator.");
            }
        }
    }
}