//
integer CMD_CHANNEL = -4545211;

integer minutes_arm = -1;
integer hours_arm = -1;


integer timezone = -8;

integer findLinkByName(string linkname)
{
    integer count = llGetNumberOfPrims();
    integer i;
    for (i=1; i<=count; i++)
    {
        if (llGetLinkName(i) == linkname)
        {
            return i;
        }
    }
    return -1;
}


menu(key k)
{
    string tz = "";
    if (timezone < 0)
        tz = "GMT-" + (string) (-timezone);
    else
        tz = "GMT+" + (string)timezone;
    
    llDialog(k, "Set Time\nTime Zone is " + tz,
        [ "+1", "-1", "Done", "SL time", "GMT" ], CMD_CHANNEL);
}

clockTick()
{
    list timestamp = llParseString2List(llGetTimestamp(),["-",":"],["T"]);
    integer hours = llList2Integer(timestamp, 4);
    integer minutes = llList2Integer(timestamp, 5);
    //llSetText((string)(timezone+hours) + ":" + (string)minutes, <1,1,0>, 1);
    llMessageLinked(minutes_arm, minutes, "", "");
    llMessageLinked(hours_arm,   ((timezone+hours)*60+minutes) / 12, "", "");
}


default
{
    state_entry()
    {
        llSetText("", <1,1,1>, 1);
        minutes_arm = findLinkByName("minutes_arm");
        hours_arm   = findLinkByName("hours_arm");
        llListen(CMD_CHANNEL, "",NULL_KEY, "" );
        clockTick();
        llSetTimerEvent(10);
    }

    touch_start(integer total_number)
    {
        menu(llDetectedKey(0));
    }
    timer()
    {
        clockTick();
    }    

    listen(integer channel, string name, key id, string msg)
    {
        if ( msg == "+1")
            timezone++;
        else if (msg == "-1")
            timezone--;
        else if (msg == "GMT")
            timezone = 0;
        else if (msg == "SL time")
            timezone = -9;
            
        if (timezone < -12)
            timezone += 24;
        if (timezone > 12)
            timezone -= 24;

        clockTick();

        if (msg != "Done")
            menu(id);
    

    }
            

}
