string ncname = "";
integer ncline = 0;
key qid = NULL_KEY;
integer dchannel = -1;
integer lchannel = -4987621;
list texturekeys = [];
list texturenames = [];
integer textures_page = 0;
integer textures_num = 0;
integer pstart = 0;
integer pend = 0;
integer setup = 1;
key owner = NULL_KEY;

texturescan()
{
    ncline = 0;
    qid = NULL_KEY;
    lchannel = -4987621;
    texturekeys = [];
    texturenames = [];
    textures_page = 0;
    textures_num = 0;
    pstart = 0;
    pend = 0;
    setup = 1;
    ncname = llGetInventoryName(INVENTORY_NOTECARD, 0);
    qid = llGetNotecardLine(ncname, ncline);
}

default
{
    state_entry()
    {
        owner = llGetOwner();
        dchannel = (integer)llFrand(-2147483392.0) - 255;
        llListen(dchannel, "", NULL_KEY, "");
        texturescan();
    }

    on_rez(integer start_param)
    {
        llResetScript();
    }

    touch_start(integer num_detected)
    {
        if (llDetectedKey(0) == owner && setup == 0)
        {
            key user = llDetectedKey(0);
            textures_num = llGetListLength(texturenames);
            if (textures_num <= 12)
            {
                llDialog(user, "Select a Time Zone:", texturenames, dchannel);
            }
            else
            {
                pstart = textures_page * 11;
                pend = ((textures_page * 11) + 11) - 1;
                llDialog(user, "Select a texture:", llList2List(texturenames, pstart, pend) + ["More..."], dchannel);
            }
        }
    }

    listen(integer channel, string name, key id, string message)
    {
        integer texturelocation = llListFindList(texturenames, [message]);
        if (texturelocation != -1)
        {
            llRegionSay(lchannel, "ttecger:" + llList2String(texturekeys, texturelocation));
        }
        else if (message == "More...")
        {
            textures_page++;
            pstart = textures_page * 11;
            pend = ((textures_page * 11) + 11) - 1;
            if ((pstart + 1) > textures_num)
            {
                textures_page = 0;
                pend = ((textures_page * 11) + 11) - 1;
                llDialog(id, "Select a texture:", llList2List(texturenames, 0, pend) + ["More..."], dchannel);
            }
            else if ((pend + 1) > textures_num)
            {
                pend = textures_num;
                llDialog(id, "Select a texture:", llList2List(texturenames, pstart, pend) + ["More..."], dchannel);
            }
            else
            {
                llDialog(id, "Select a texture:", llList2List(texturenames, pstart, pend) + ["More..."], dchannel);
            }
        }
    }

    changed(integer mask)
    {
        if(mask & CHANGED_INVENTORY)
        {
            texturescan();
        }
    }

    dataserver(key query_id, string data) {
        if (query_id == qid) {
            llSetText("Config: Line " + (string)ncline, <1.0, 1.0, 1.0>, 1.0);
            if (data != EOF) {
                if (llGetSubString(data, 0, 1) != "//") {
                    integer split = llSubStringIndex(data, "channel:");
                    if (split != -1) {
                        lchannel = (integer)llGetSubString(data, split + 8, -1);
                    } else {
                        split = llSubStringIndex(data, ":");
                        if (split != -1) {
                            texturekeys = (texturekeys=[]) + texturekeys + [llGetSubString(data, split + 1, -1)];
                            if ((split - 1) > 23) split = 24;
                            texturenames = (texturenames=[]) + texturenames + [llGetSubString(data, 0, split - 1)];
                        }
                    }
                }
                ++ncline;
                qid = llGetNotecardLine(ncname, ncline);
            } else {
                llSetText("", <1.0, 1.0, 1.0>, 1.0);
                setup = 0;
            }
        }
    }
}