/*MONEY HUD SCRIPT
This script keeps track of how much money an avatar has at all times. 
This script is responsible for communicating with trees.
Last updated 5-11-2012
*/

//url of the page for writing to the database
string write = "http://sciethics.net/points_write.php";

//url of the page for reading from the database
string read = "http://sciethics.net/points_read.php"; 

//the key of the http request. used in error/false alarm checking.
key requestKey;

//the reason for the httpRequest. Useful in determining what request httpResponses are responding to.
integer httpReason = 0;
integer ASK = 1;
integer WRITE = 2;

//how many points the avatar currently has.
integer avatar_points;

//the owner of this HUD
key owner;

//up this value to give avatars more points to work with.
integer MAX_POINTS = 200;

//channel for listening to trees
integer whisperChannel = -90909;

//the tree’s randomly generated channel for the HUD to respond on.
//the HUD doesn’t need to listen on this channel
integer treesRandomChannel;

//handle for listening to the dialog the hud shows the user
integer dialogHandle;

//the random channel this HUD uses to listen to its own dialog.
//saves itself some memory by just using the treesRandomChannel + 1
integer HUDRandomChannel;

integer DIAMETER_COST = 1;
integer SPECIES_COST = 5;
integer HEIGHT_COST = 10;
integer PRICE_FOR_DATA; //how much user will pay for data. one of the above values.

integer EQUATION_CHOICE = -1;
integer SIMPLE_EQUATION = 1;
integer MEDIUM_EQUATION = 2;
integer COMPLEX_EQUATION = 3;

//a list of all trees sampled since last script reset
list sampled_trees = [];
//the very last tree we've clicked on.
key last_tree = NULL_KEY;


/*function for ASKING for database info.
  This function needs to be supplied with an avatar's key.
*/
askForPoints(key avatarKey)
{
    string body = "";
    
        //question mark denotes the beginning of the query string in the url
        //ampersand seperates the field/value pairs.
    string URL = read + "?" + "key=" + (string)avatarKey;

    list parameters = [HTTP_METHOD, "GET"];
    
    httpReason = ASK;
    requestKey = llHTTPRequest(URL, parameters, body);
}
    



/*function for WRITING to the database.
  This will only happen when an avatar spends points.
  Function needs the avatar's key and their points.
*/

updatePoints(key avatarKey, integer points)
{
    string body = "";
    
        //question mark denotes the beginning of the query string in the url
        //ampersand separates the field/value pairs.
    string URL = write + "?" + "key=" + (string)avatarKey + "&" + "points=" + (string)points;

    list parameters = [HTTP_METHOD, "GET"];
    
    httpReason = WRITE;
    requestKey = llHTTPRequest(URL, parameters, body);
}


string trim(string in)
{
    string test = llGetSubString(in, 0, 0);
    if(test == " " || test == "\n" )
    {
        return trim(llGetSubString(in, 1, -1));
    }
    
    return in;
} 


//returns a random integer between min and max 
//CAN RETURN MAX OR MIN
integer random_integer( integer min, integer max )
{
     return min + (integer)( llFrand( max - min + 1 ) );
}


//returns either the empty list or a non empty list.
list listXandY(list lx, list ly) {// return a list of elements common to both lists
    list lz = []; integer x;
    for (x = 0; x < llGetListLength(ly); x++) {
        if (~llListFindList(lx,llList2List(ly,x,x))) {
            lz = lz + llList2List(ly,x,x);
        }
        else {
            ;
        }
    }
    return lz;
}



default
{
    on_rez(integer params)
    {
        llResetScript();
    }
    
    state_entry()
    {   
        //llOwnerSay("money hud running");
        //save time later when it will be more important,
        //just get the owner now.
        owner = llGetOwner();

        //get points set up
        state preparePoints;
    }
    
    attach(key attached)
    {
        if (attached == NULL_KEY)  // object has been detached
        {
            llOwnerSay("You've removed your data collection HUD.");
            //llSetScriptState(llGetScriptName(), FALSE);
        } 
        else
        {
            llResetScript();
        }
    }
            
}

state preparePoints
{
    state_entry()
    {
        askForPoints(owner);       
    }
    
    http_response( key request_id, integer status, list metadata, string body )
    {
        //llOwnerSay("hhtp response in state prepare points reached");
        
        if(request_id == requestKey)
        {
            //if reason for the http request was to ask for data:
            if(httpReason == ASK)
            {    
                body = trim(body);
    
                integer temp_points = (integer)body;
    
                if(temp_points < 0) //implies the avatar is new. they have MAX_POINTS points to start with.
                {
                    avatar_points = MAX_POINTS;
                }
                else 
                { //update the avatar’s points based on the response.
    
                    avatar_points = temp_points;
                }
                
                llMessageLinked(LINK_ALL_OTHERS, avatar_points, "", NULL_KEY);

                httpReason = 0;
            }

            else
            {
                llOwnerSay("Error - hhtp reason not ASK in state preparePoints.");
            }    
        }
        
        state chooseEquation;
    }
    
    attach(key attached)
    {
        if (attached == NULL_KEY)  // object has been detached
        {
            llOwnerSay("You've removed your data collection HUD.");
            //llSetScriptState(llGetScriptName(), FALSE);
        } 
        else
        {
            llResetScript();
        }
    }
}

state chooseEquation
{
    state_entry()
    {
        //llOwnerSay((string)treesRandomChannel);
        HUDRandomChannel = random_integer(-9999999, -1);

        dialogHandle = llListen(HUDRandomChannel, "", owner, "");
            
        //prepare the dialog.
        string prompt = "Please select the equation you would like to use:\n" +
                            "A) Simplistic Equation\n" +
                            "B) Medium Equation\n" +
                            "C) Complex Equation\n";
        list options = ["A", "B", "C"];
                
        llSetTimerEvent(30.0); //in case the user ignores the dialog.

        llDialog(owner, prompt, options, HUDRandomChannel);
    }
    
    listen( integer channel, string name, key id, string msg)
    {
        if(id == owner)
        {  
            //llOwnerSay("Heard owner dialog response.");

            //first get rid of the listen handle
            llListenRemove(dialogHandle);

            //and turn off the timer
            llSetTimerEvent(0.0);

            if(msg == "A")
            {
                EQUATION_CHOICE = SIMPLE_EQUATION;
                //animation = "diameter_anim";
                PRICE_FOR_DATA = DIAMETER_COST;
                llOwnerSay("You've selected the simplistic equation.");
                state collectData;
            }
            else if (msg == "B")
            {
                EQUATION_CHOICE = MEDIUM_EQUATION;
                //animation = "species_anim";
                PRICE_FOR_DATA = SPECIES_COST;
                llOwnerSay("You've selected the equation of medium complexity.");
                state collectData;
            }

            else if (msg == "C")
            {
                EQUATION_CHOICE = COMPLEX_EQUATION;
                //animation = "height_animation";
                PRICE_FOR_DATA = HEIGHT_COST;
                llOwnerSay("You've selected the complex equation.");
                state collectData;
            }
            else
            {
                llOwnerSay("You will not be able to collect data without choosing an equation.");
                llOwnerSay("Detach, then reattach the HUD to try again.");
            }
        }
    }
    
    timer()
    {
        //timer event raised if user never responds to dialog. tell him off proper good.
        llOwnerSay("You will not be able to collect data without choosing an equation.");
        llOwnerSay("Detach, then reattach the HUD to try again.");
    }
    
    attach(key attached)
    {
        if (attached == NULL_KEY)  // object has been detached
        {
            llOwnerSay("You've removed your data collection HUD.");
            //llSetScriptState(llGetScriptName(), FALSE);
        } 
        else
        {
            llResetScript();
        }
    }
}

state collectData
{
    state_entry()
    {
        //start listening for trees
        llListen(whisperChannel, "", NULL_KEY, "");
        
        llOwnerSay("Data Collection HUD now ready.\nClick on trees to collect data.");
    }
    
    attach(key attached)
    {
        if (attached == NULL_KEY)  // object has been detached
        {
            llOwnerSay("You've removed your data collection HUD.");
            //llSetScriptState(llGetScriptName(), FALSE);
        } 
        else
        {
            llResetScript();
        }
    }
    
    http_response( key request_id, integer status, list metadata, string body )
    {
        if(request_id == requestKey)
        {
            if(httpReason == WRITE)
            { 
                httpReason = 0;
            }

            else
            {
                llOwnerSay("Error - http reason not WRITE in state collectData.");
            }    
        }
    }
    
    timer()
    {
        llSetTimerEvent(0);
        llListenRemove(dialogHandle);
        llOwnerSay("You waited too long to respond.");
    }
    
    listen( integer channel, string name, key id, string msg)
    {
        if(id == owner)
        {  
            //llOwnerSay("You reponded to Dialog.");
            //this message is from the owner 
            //it is a response to the dialog.

            //first get rid of the listen handle
            llListenRemove(dialogHandle);

            //and turn off the timer
            llSetTimerEvent(0.0);

            if(msg == "Yes")
            {
                //check which equations we're working with.
                //if is the simple one, just do the diameter animation
                //if its the medium one, do the diameter animation or the species animation
                //if it's the complex one, do any of the three animations.
                integer animationToDo = 1;
                if(!(EQUATION_CHOICE == SIMPLE_EQUATION))
                {
                    //llOwnerSay("Not Simple Equation");
                    if(EQUATION_CHOICE == MEDIUM_EQUATION)
                    {
                        //get a random number that's 1 or 2
                        animationToDo = random_integer(1,2);
                    } 
                    else
                    {
                        //llOwnerSay("Complex Equation");
                        //equation choice must be the complex one.
                        //get a rnd between 1 and 3
                        animationToDo = random_integer(1,3);
                    }
                }
                //llOwnerSay("AnimationToDo == " + (string)animationToDo);
                
                if(animationToDo == 1)
                {
                    osAvatarPlayAnimation(owner, "diameter_anim");
                } 
                else if (animationToDo == 2)
                {
                    osAvatarPlayAnimation(owner, "species_anim");
                }
                else
                {
                    //this animation not implemented yet.
                    osAvatarPlayAnimation(owner, "height_anim");
                }   
                    
                
                llSleep(2.0);
                
                avatar_points -= PRICE_FOR_DATA;
                llWhisper(treesRandomChannel, (string)EQUATION_CHOICE);
                updatePoints(owner, avatar_points);
                
                //add this tree to the list of sampled trees
                sampled_trees += [last_tree];
                last_tree = NULL_KEY;
            }
            else if (msg == "No")
            {
                llWhisper(treesRandomChannel, "0"); 
            }
            
            //change the points display.
            llMessageLinked(LINK_ALL_OTHERS, avatar_points, "", NULL_KEY);
        }
        else //this message is not from the owner. from a tree perhaps?
        {

            key userKey = (key)llDeleteSubString(msg, 36, -1);

            if(userKey == owner)
            {
                //first check whether this person even has enough points.
                if( (EQUATION_CHOICE == SIMPLE_EQUATION && avatar_points >= DIAMETER_COST) 
                    ||
                    (EQUATION_CHOICE == MEDIUM_EQUATION && avatar_points >= SPECIES_COST)
                    ||
                    (EQUATION_CHOICE == COMPLEX_EQUATION && avatar_points >= HEIGHT_COST) )
                {
                    last_tree = id;
                        
                    //find out whether we've talked to this tree before.
                    if(listXandY(sampled_trees, [last_tree]) == [])
                    {    
                        //a new tree
                        //dont add it to the list just yet;
                        //we haven't actually sampled it yet.
                        
                        //a new tree friend!
                        treesRandomChannel = (integer)llDeleteSubString(msg, 0, -6);
                
                
                        //llOwnerSay((string)treesRandomChannel);
                        HUDRandomChannel = treesRandomChannel + 1;

                        dialogHandle = llListen(HUDRandomChannel, "", owner, "");
            
                    
                        //prepare the dialog.
                        string prompt = "Collect data for this tree?";
                        list options = ["Yes", "No"];

                        llSetTimerEvent(15.0); //in case the user ignores the dialog.

                        llDialog(owner, prompt, options, HUDRandomChannel);
                    }
                    else
                    {
                        llOwnerSay("You've already sampled this tree.");
                    }
                } 
                else //user doesn't have enough points
                {
                    llOwnerSay("You don't have enough money to collect more data.");
                    
                    //send away the tree.
                    //treesRandomChannel = (integer)llDeleteSubString(msg, 0, -6);
                    //llWhisper(treesRandomChannel, "0");
                }
            }
            //else the tree isn’t talking to me. mind my business. 
        }
    }
}

