
// PPT Slideshow for Opensim Script
//
// Based on a script created in September 2007
// by Dr. Allen Partridge (SL: DoctorPartridge Allen)
//
// Modifications by Chad Sherman to allow for reset and backward browsing.
// Modifications by Dr. Partridge June 08 to fix the lag probs common in slide viewers.
// Modifications by Ryon Steele (SL: Ryon Bloobury) 2010 to work in Opensim.
//
// Original script permissions from Dr. Partridge:
// "Feel free to use as you desire.. You can reprogram the script as you like - but
// please send updates to DoctorPartridge Allen in sl if you do."
//
// -------------------------------------------------------------------------------------
 
integer pCurrentSlide = 0;
integer pSlideCount;
integer pLockState = 0;
list pAccessList = [];
integer dialog_channel= 1751;
key pLastId;
list tTest;
string person;
integer foundIndex;
string name4;
string name;
string name1;
string name2;
string name3;
string name5;
 
default
{
    state_entry()
    {
         llListen(dialog_channel,"", "","");
         integer number = llGetInventoryNumber(INVENTORY_TEXTURE);
         pSlideCount = number;
         string name1 = llGetInventoryName(INVENTORY_TEXTURE, 1);
         string name2 = llGetInventoryName(INVENTORY_TEXTURE, 2);
         string name3 = llGetInventoryName(INVENTORY_TEXTURE, 3);
         string name4 = llGetInventoryName(INVENTORY_TEXTURE, 4);
         string name5 = llGetInventoryName(INVENTORY_TEXTURE, 5);
         llSetLinkTexture(4, name1, 3);
         llSetLinkTexture(5, name2, 3);
         llSetLinkTexture(6, name3, 3);
         llSetLinkTexture(7, name4, 3);
         llSetLinkTexture(8, name5, 3);
         string name = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide);
         llSetTexture(name, 3);
         if (pLockState  == 0)
         {
             llSetLinkTexture(10, "940d8057-e0da-4d14-a912-8c809e11ee36", 3);  //locked texture
            }else{
             llSetLinkTexture(10, "b22af52f-f34e-4f93-ae71-95831dfd87a6", 3);  //unlocked texture
         }
    }
        on_rez(integer start_param)
    {
        llResetScript();
    }
    touch_start(integer total_number)
        {
            pLastId = llDetectedKey(0);
        integer number = llGetInventoryNumber(INVENTORY_TEXTURE);
        pSlideCount = number;
        string button = llGetLinkName(llDetectedLinkNumber(0));
        if (button == "lock")
        {
        }else{
            if (pLockState == 1)
            {
                if (llDetectedKey(0) != llGetOwner())
                {
                     person = llDetectedName(0);
                     tTest = [person];
 
                     foundIndex = llListFindList(pAccessList, tTest);
                    if (foundIndex == -1)
                    {
                        llInstantMessage(llDetectedKey(0), "You do not have permission to use this viewer.");
                        llInstantMessage(llDetectedKey(0), "You may request permission from the owner, by clicking the lock on the side of the screen.");
                        return;
                    }
                }
            }
        }
        list tButtonList = ["back", "open", "1","2","3","4","5","next","lock"];
         tTest = [(button)];
         foundIndex = llListFindList(tButtonList, tTest);
        if (foundIndex == -1)
        {
            if (pCurrentSlide < pSlideCount)
            {
                pCurrentSlide += 1;
                }else{
                pCurrentSlide = 0;
            }
        }
        if (button == "lock")
        {
            if (llDetectedKey(0) != llGetOwner())
            {
                person = llDetectedName(0);
                 tTest = [person];
                 foundIndex = llListFindList(pAccessList, tTest);
                if (foundIndex == -1)
                {
                    list pApprovalMenu = [];
                    list tList = [(person), "No Access"];
                    pApprovalMenu = llListInsertList(pApprovalMenu, tList, 0);
                    llDialog( llGetOwner(), ("\n \n"+person+" has asked to use your slide viewer. Grant permission to whom?"), pApprovalMenu, dialog_channel );
                }else{
                    llInstantMessage(llDetectedKey(0), ((person) + " is logging out. Access control is now removed for this user."));
                    pAccessList = llDeleteSubList(pAccessList, foundIndex, foundIndex);
                }
            }else{
                if (pLockState == 0) {
                    pLockState = 1;
                    llSetLinkTexture(10, "0aede32a-d379-49b7-ab0e-e2d35ec27b3a", 3);  //locked texture
                }else{
                    pLockState = 0;
                    llSetLinkTexture(10, "d95efd1e-45b8-4931-9cba-9b70a28fc596", 3);  //unlocked texture
                }
            }
        }
    if (button == "back")
    {
        if (pCurrentSlide > 0)
        {
            pCurrentSlide = pCurrentSlide - 1;
        }else{
            pCurrentSlide = pSlideCount - 1;
        }
    }
    if (button == "open")
    {
        pCurrentSlide = 0;
    }
    if (button == "1")
    {
        if (pCurrentSlide < pSlideCount)
        {
            pCurrentSlide += 1;
        }else{
            pCurrentSlide = 0;
        }
    }
    if (button == "2")
    {
        if (pCurrentSlide+2 < pSlideCount)
        {
            pCurrentSlide += 2;
        }else{
            integer dif = (pSlideCount - pCurrentSlide);
            pCurrentSlide = 2-dif;
        }
    }
    if (button == "3")
    {
        if (pCurrentSlide+3 < pSlideCount)
        {
            pCurrentSlide += 3;
        }else{
            integer dif = (pSlideCount - pCurrentSlide);
            pCurrentSlide = 3-dif;
        }
    }
    if (button == "4")
    {
        if (pCurrentSlide+4 < pSlideCount)
        {
            pCurrentSlide += 4;
        }else{
            integer dif = (pSlideCount - pCurrentSlide);
            pCurrentSlide = 4-dif;
        }
    }
    if (button == "5")
    {
        if (pCurrentSlide+5 < pSlideCount)
        {
            pCurrentSlide += 5;
        }else{
            integer dif = (pSlideCount - pCurrentSlide);
            pCurrentSlide = 5-dif;
        }
    }
    if (button == "next")
    {
        if (pCurrentSlide < pSlideCount)
        {
            pCurrentSlide += 1;
        }else{
            pCurrentSlide = 0;
        }
    }
    string name = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide);
    if (name != "") {
        llSetTexture(name, 3);
    }else{
        pCurrentSlide = 0;
         name = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide);
        llSetTexture(name, 3);
    }
    if (pCurrentSlide + 1 < pSlideCount) {
         name1 = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide+1);
         llSetLinkTexture(4, name1, 3);
    }else{
        integer dif = (pSlideCount - pCurrentSlide);
         name1 = llGetInventoryName(INVENTORY_TEXTURE, 1-dif);
        llSetLinkTexture(4, name1, 3);
    }
    if (pCurrentSlide + 2 < pSlideCount) {
         name2 = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide + 2);
        llSetLinkTexture(5, name2, 3);
    }else{
        integer dif = (pSlideCount - pCurrentSlide);
         name2 = llGetInventoryName(INVENTORY_TEXTURE, 2-dif);
        llSetLinkTexture(5, name2, 3);
    }
    if (pCurrentSlide + 3 < pSlideCount) {
         name3 = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide + 3);
        llSetLinkTexture(6, name3, 3);
    }else{
        integer dif = (pSlideCount - pCurrentSlide);
         name3 = llGetInventoryName(INVENTORY_TEXTURE, 3-dif);
        llSetLinkTexture(6, name3, 3);
    }
    if (pCurrentSlide + 4 < pSlideCount) {
         name4 = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide + 4);
        llSetLinkTexture(7, name4, 3);
    }else{
        integer dif = (pSlideCount - pCurrentSlide);
         name4 = llGetInventoryName(INVENTORY_TEXTURE, 4-dif);;
        llSetLinkTexture(7, name4, 3);
    }
    if (pCurrentSlide + 5 < pSlideCount) {
         name5 = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide + 5);
        llSetLinkTexture(8, name5, 3);
    }else{
        integer dif = (pSlideCount - pCurrentSlide);
         name5 = llGetInventoryName(INVENTORY_TEXTURE, 5-dif);
        llSetLinkTexture(8, name5, 3);
    }
}
    listen(integer incoming_channel, string name, key id, string mes)
    {
    if(id == llGetOwnerKey(id)){
        if (incoming_channel == dialog_channel){
            if (mes != "No Access"){
                llInstantMessage(pLastId, (name + " has granted "+mes+" permission to use their slide viewer."));
                list insertNameList = [(mes)];
                list tTest = [mes];
                integer foundIndex = llListFindList(pAccessList, tTest);
                    if (foundIndex == -1){
                        pAccessList = llListInsertList(pAccessList, insertNameList, 0);
                    }else{
                        llInstantMessage(pLastId, (mes+ " was already on the access list."));
                    }
            }else{
                llInstantMessage(pLastId, (name + " has denied your request for permission to use their slide viewer."));
            }
            }
        }
    }
}
 