// This script is a modification of Doctor Partridge's presenter script (Preso-Matic Turbo).  Code for a laser pointer originally written by Prospero Frobozz (Laser Pointer, for Troy McLuhan's Slide Presentation Screen v7.0) has been added to Doc Partridge's script.

// Comments added by Azzura Supplee
// If you ever unlink this board - it will stop functioning unless you relink in  the proper order
// start with the shell and anything else added then
// Pointer (12) - Pointer Button - Lock Button - Right Arrow - first square on right and work your way to the left arrow
// Viewscreen last (1)


integer pCurrentSlide = 0;
integer pSlideCount;
integer pLockState = 0;
list pAccessList = [];
integer dialog_channel= 1751;
key pLastId;

integer laserPointerOn = FALSE;
integer laserPointerLinkNum = 12;
integer laserPointerButtonLinkNum = 11; 
 

default
{
    state_entry()
    {
         llListen(dialog_channel,"", "","");
         integer number = llGetInventoryNumber(INVENTORY_TEXTURE);
         pSlideCount = number;
         string name1 = llGetInventoryName(INVENTORY_TEXTURE, 1);
         string name2 = llGetInventoryName(INVENTORY_TEXTURE, 2);
         string name3 = llGetInventoryName(INVENTORY_TEXTURE, 3);
         string name4 = llGetInventoryName(INVENTORY_TEXTURE, 4);
         string name5 = llGetInventoryName(INVENTORY_TEXTURE, 5);
         llSetLinkTexture(4, name1, 3);
         llSetLinkTexture(5, name2, 3);
         llSetLinkTexture(6, name3, 3);
         llSetLinkTexture(7, name4, 3);
         llSetLinkTexture(8, name5, 3);
         string name = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide);
         llSetTexture(name, 3);  
         if (pLockState  == 0) 
         {
             llSetLinkTexture(10, "7eb8c1f6-2b4f-43a2-ae07-f99482a5c6e2", 1);
            }else{
             llSetLinkTexture(10, "d522d078-0fdc-4393-a0d8-cb0b587eadba", 1);
         }
        
         // initiallze (/OFF) the laserPointer & laserPointerButton...
        llMessageLinked(laserPointerLinkNum, 0, "", "");
        llSetLinkColor( laserPointerButtonLinkNum, <1.0, 0.0, 0.0>, 0  );
         
                          
                                                              
    }
        on_rez(integer start_param)
    {
        llResetScript(); 
    }
    touch_start(integer total_number)
        {
            list tTest;
            integer foundIndex;
            pLastId = llDetectedKey(0);
        integer number = llGetInventoryNumber(INVENTORY_TEXTURE);
        pSlideCount = number;
        string button = llGetLinkName(llDetectedLinkNumber(0)); 
        if (button == "lock")
        {
        }else{
            if (pLockState == 1)
            {
                if (llDetectedKey(0) != llGetOwner())
                {
                    string person = llDetectedName(0);
                    tTest = [person];
                    foundIndex =llListFindList(pAccessList, tTest);
                    if (foundIndex == -1)
                    {
                        llInstantMessage(llDetectedKey(0), "You do not have permission to use this viewer.");
                        llInstantMessage(llDetectedKey(0), "You may request permission from the owner, by clicking the lock on the side of the screen.");
                        return;
                    }
                }
            }
        }
                
        list tButtonList = ["back", "reset", "1","2","3","4","5","next","lock", "laserPointer"];  // labels for the prims
        tTest = [(button)];
        foundIndex = llListFindList(tButtonList, tTest);
        if (foundIndex == -1)
        {
            
            // handle laser pointer here, if laserPointerOn == TRUE, then RETURN
            if ( laserPointerOn == TRUE ) {
                
                vector pos = llDetectedTouchPos(0);
                
                if (pos == ZERO_VECTOR)
                {
                    llSay(0, "Warning : the laser pointer requires version 1.21 or higher of the SL viewer.");
                    return;
                }
                
                vector norm = llDetectedTouchNormal(0);
                norm = llVecNorm(norm);
                pos += 0.001*norm - llGetPos();
                pos /= llGetRot();
                
                llMessageLinked(laserPointerLinkNum, 2, (string)pos, "");
                    
                return;   
            }
            
            
            if (pCurrentSlide < pSlideCount) 
            { 
                pCurrentSlide += 1;
                }else{
                pCurrentSlide = 0;
            }
        }
        
        // handle laserPointer On/Off button presses...
        if ( button == "laserPointer" ) {
            
            if ( laserPointerOn == TRUE ) {
                
                laserPointerOn = FALSE;
                llMessageLinked(laserPointerLinkNum, 0, "", "");
                // change button color
                llSetLinkColor( laserPointerButtonLinkNum, <1.0, 0.0, 0.0>, 0  );
                
            } else {
                
                laserPointerOn = TRUE;
                llMessageLinked(laserPointerLinkNum, 1, "", "");                
                llSetLinkColor( laserPointerButtonLinkNum, <0.0, 1.0, 0.0>, 0  );
                
            }
            
            
            
            
            
        }
        
        if (button == "lock")
        {
            if (llDetectedKey(0) != llGetOwner())
            {
                string person = llDetectedName(0);
                tTest = [person];
                foundIndex = llListFindList(pAccessList, tTest);
                if (foundIndex == -1)
                {
                    list pApprovalMenu = [];
                    list tList = [(person), "No Access"];
                    pApprovalMenu = llListInsertList(pApprovalMenu, tList, 0);
                    llDialog( llGetOwner(), ("\n \n"+person+" has asked to use your slide viewer. Grant permission to whom?"), pApprovalMenu, dialog_channel );
                }else{
                    llInstantMessage(llDetectedKey(0), ((person) + " is logging out. Access control is now removed for this user."));
                    pAccessList = llDeleteSubList(pAccessList, foundIndex, foundIndex);
                }
            }else{
                if (pLockState == 0) {
                    pLockState = 1;
                    llSetLinkTexture(10, "7eb8c1f6-2b4f-43a2-ae07-f99482a5c6e2", 1);
                }else{
                    pLockState = 0;
                    llSetLinkTexture(10, "d522d078-0fdc-4393-a0d8-cb0b587eadba", 1);
                } 
            }     
        }
    if (button == "back")
    {
        if (pCurrentSlide > 0) 
        { 
            pCurrentSlide = pCurrentSlide - 1;
        }else{
            pCurrentSlide = pSlideCount - 1;
        }
    }
    if (button == "reset")
    {
        pCurrentSlide = 0;
    }
    if (button == "1")
    {
        if (pCurrentSlide < pSlideCount) 
        { 
            pCurrentSlide += 1;
        }else{
            pCurrentSlide = 0;
        }
    }
    if (button == "2")
    {
        if (pCurrentSlide+2 < pSlideCount) 
        { 
            pCurrentSlide += 2;
        }else{
            integer dif = (pSlideCount - pCurrentSlide);
            pCurrentSlide = 2-dif;
        }
    }
    if (button == "3")
    {
        if (pCurrentSlide+3 < pSlideCount) 
        { 
            pCurrentSlide += 3;
        }else{
            integer dif = (pSlideCount - pCurrentSlide);
            pCurrentSlide = 3-dif;
        }
    }
    if (button == "4")
    {
        if (pCurrentSlide+4 < pSlideCount) 
        { 
            pCurrentSlide += 4;
        }else{
            integer dif = (pSlideCount - pCurrentSlide);
            pCurrentSlide = 4-dif;
        }
    }
    if (button == "5")
    {
        if (pCurrentSlide+5 < pSlideCount) 
        { 
            pCurrentSlide += 5;
        }else{
            integer dif = (pSlideCount - pCurrentSlide);
            pCurrentSlide = 5-dif;
        }
    }      
    if (button == "next")
    {
        if (pCurrentSlide < pSlideCount) 
        { 
            pCurrentSlide += 1;
        }else{
            pCurrentSlide = 0;
        }
    }
    string name = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide);
    if (name != "") {
        llSetTexture(name, 3);
    }else{
        pCurrentSlide = 0;
        name = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide);
        llSetTexture(name, 3);
    }
    if (pCurrentSlide + 1 < pSlideCount) {
         string name1 = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide+1);
         llSetLinkTexture(4, name1, 3);
    }else{
        integer dif = (pSlideCount - pCurrentSlide);
        string name1 = llGetInventoryName(INVENTORY_TEXTURE, 1-dif);
        llSetLinkTexture(4, name1, 3);
    }
    if (pCurrentSlide + 2 < pSlideCount) {
        string name2 = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide + 2);
        llSetLinkTexture(5, name2, 3);
    }else{
        integer dif = (pSlideCount - pCurrentSlide);
        string name2 = llGetInventoryName(INVENTORY_TEXTURE, 2-dif);
        llSetLinkTexture(5, name2, 3);
    }
    if (pCurrentSlide + 3 < pSlideCount) {
        string name3 = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide + 3);
        llSetLinkTexture(6, name3, 3);
    }else{
        integer dif = (pSlideCount - pCurrentSlide);
        string name3 = llGetInventoryName(INVENTORY_TEXTURE, 3-dif);
        llSetLinkTexture(6, name3, 3);
    }
    if (pCurrentSlide + 4 < pSlideCount) {
        string name4 = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide + 4);
        llSetLinkTexture(7, name4, 3);
    }else{
        integer dif = (pSlideCount - pCurrentSlide);
        string name4 = llGetInventoryName(INVENTORY_TEXTURE, 4-dif);;
        llSetLinkTexture(7, name4, 3);
    }
    if (pCurrentSlide + 5 < pSlideCount) {
        string name5 = llGetInventoryName(INVENTORY_TEXTURE, pCurrentSlide + 5);
        llSetLinkTexture(8, name5, 3);
    }else{
        integer dif = (pSlideCount - pCurrentSlide);
        string name5 = llGetInventoryName(INVENTORY_TEXTURE, 5-dif);
        llSetLinkTexture(8, name5, 3);
    }     
}
    listen(integer incoming_channel, string name, key id, string mes)
    {
    if(id == llGetOwnerKey(id)){
        if (incoming_channel == dialog_channel){
            if (mes != "No Access"){
                llInstantMessage(pLastId, (name + " has granted "+mes+" permission to use their slide viewer."));
                list insertNameList = [(mes)];
                list tTest = [mes];
                integer foundIndex = llListFindList(pAccessList, tTest);
                    if (foundIndex == -1){
                        pAccessList = llListInsertList(pAccessList, insertNameList, 0);
                    }else{
                        llInstantMessage(pLastId, (mes+ " was already on the access list."));   
                    }
            }else{
                llInstantMessage(pLastId, (name + " has denied your request for permission to use their slide viewer."));
            }
            }
        }
    }
}
