//============================================================================
//                          Prim Mirroring Script Set
//                           Written by Jeffrey Gomez
//
//     Permissions Granted to Edit, Copy, Transfer, and Sell this script
//      to any user, so long as this comment set remains intact, and is 
//        granted WITHOUT ANY WARRANTY. USE AT OWN RISK. And enjoy. =]
//
//   For Instructions on Usage, Limitations, etc, see PrimPorter Mirror Code
//============================================================================
list params = [];
list params2 = [];
default
{
    state_entry()
    {
        llListen(19000,"","","");
        llListen(18999,"","","");
    }

    listen(integer chan, string name, key id, string msg)
    {
        if(chan == 19000)
            params = llParseString2List(msg,[":"],[]);
        else if(chan == 18999)
        { 
            if(msg != "done") 
                params2 = llParseString2List(msg,[":"],[]);
            string mirror = llList2String(params,0);
            vector pos = ((vector)llList2String(params,1) - llGetPos()) / llGetRot();
            rotation rot = (rotation)llList2String(params,2) / llGetRot();
            vector size = (vector)llList2String(params,3);
            integer type = (integer)llList2String(params,4);
            if(type < 3)
            {
                integer holeshape = (integer)llList2String(params,5);
                vector cut = (vector)llList2String(params,6);
                float hollow = (float)llList2String(params,7);
                vector twist = (vector)llList2String(params,8);
                vector topsize = (vector)llList2String(params,9);
                vector topshear = (vector)llList2String(params,10);
    
                vector rot2 = llRot2Euler(rot);
                //if(type == 0) 
                cut = <1 - cut.y, 1 - cut.x, 0>;
                topshear = <topshear.y,topshear.x,0>;
                topsize = <topsize.y,topsize.x,0>;
                twist *= -1;
                size = <size.y,size.x,size.z>;
                if(mirror == "X")
                {
                    pos.x *= -1;
                    rot2.y *= -1;
                    rot2.z *= -1;
                    rot = <0.00000, 0.00000, 0.70711, 0.70711> * llEuler2Rot(rot2);
                }
                else if(mirror == "Y")
                {
                    pos.y *= -1;
                    rot2.x *= -1;
                    rot2.z *= -1;
                    rot = <0.00000, 0.00000, -0.70711, 0.70711> * llEuler2Rot(rot2);
                }
                else if(mirror == "Z")
                {
                    pos.z *= -1;
                    rot2.x *= -1;
                    rot2.y *= -1;
                    rot = <-0.70711, -0.70711, -0.00000, 0.00000> * llEuler2Rot(rot2);
                }
                if(type == 2 || type == 1)
                {
                    topshear = <topshear.y,-1 * topshear.x,0>;
                    topsize = <topsize.y,topsize.x,0>;
                    rot2 = llRot2Euler(rot);
                    rot2.z += PI_BY_TWO;
                    rot = llEuler2Rot(rot2);
                    size = <size.y,size.x,size.z>;
                }
                pos = llGetPos() + (pos * llGetRot());
                rot = rot * llGetRot();
                params = [pos,rot,size,type,holeshape,cut,hollow,twist,topsize,topshear];
            }
            else if(type == 3)
            {
                integer holeshape = (integer)llList2String(params,5);
                vector cut = (vector)llList2String(params,6);
                float hollow = (float)llList2String(params,7);
                vector twist = (vector)llList2String(params,8);
                vector dimple = (vector)llList2String(params,9);
    
                vector rot2 = llRot2Euler(rot);
                cut = <1 - cut.y, 1 - cut.x, 0>;
                //dimple = <1 - dimple.y,1 - dimple.x,0>;
                twist = <twist.y,twist.x,0>;
                if(mirror == "X")
                {
                    pos.x *= -1;
                    rot2.z *= -1;
                    rot2.y *= -1;
                    rot = <-0.00000, -1.00000, -0.00000, 0.00000> * llEuler2Rot(rot2);
                }
                else if(mirror == "Y")
                {
                    pos.y *= -1;
                    rot2.x *= -1;
                    rot2.z *= -1;
                    rot = <1.00000, -0.00000, -0.00000, 0.00000> * llEuler2Rot(rot2);
                }
                else if(mirror == "Z")
                {
                    pos.z *= -1;
                    rot2.x *= -1;
                    rot2.y *= -1;
                    rot = llEuler2Rot(rot2);
                }
                pos = llGetPos() + (pos * llGetRot());
                rot = rot * llGetRot();
                params = [pos,rot,size,type,holeshape,cut,hollow,twist,dimple];
            }
            else if(type > 3)
            {
                integer holeshape = (integer)llList2String(params,5);
                vector cut = (vector)llList2String(params,6);
                float hollow = (float)llList2String(params,7);
                vector twist = (vector)llList2String(params,8);
                vector holesize = (vector)llList2String(params,9);
                vector topshear = (vector)llList2String(params,10);
                vector advancedcut = (vector)llList2String(params2,0);
                vector taper = (vector)llList2String(params2,1);
                float revolutions = (float)llList2String(params2,2);
                float radiusoffset = (float)llList2String(params2,3);
                float skew = (float)llList2String(params2,4);
                
                cut = <1 - cut.y, 1 - cut.x, 0>;
                twist = <twist.y,twist.x,0>;
                topshear = <topshear.x * -1,topshear.y * -1,0>;
                taper *= -1;
                radiusoffset *= -1;
                skew *= -1;
                if(mirror == "X")
                {
                    vector rot2 = llRot2Euler(rot);
                    rot2.y *= -1;
                    rot2.y += PI;
                    rot = llEuler2Rot(rot2);
                    pos.x *= -1;
                }
                else if(mirror == "Y")
                {
                    pos.y *= -1;
                    vector rot2 = llRot2Euler(rot);
                    rot2.x *= -1;
                    rot2.x += PI;
                    rot2.y *= -1;
                    rot = llEuler2Rot(rot2);
                }
                else if(mirror == "Z")
                {
                    pos.z *= -1;
                    vector rot2 = llRot2Euler(rot);
                    rot2.x *= -1;
                    rot2 += <PI,PI,PI>;
                    rot = llEuler2Rot(rot2);
                }
                pos = llGetPos() + (pos * llGetRot());
                rot = rot * llGetRot();
                params = [pos,rot,size,type,holeshape,cut,hollow,twist,holesize,topshear];
                params2 = [advancedcut,taper,revolutions,radiusoffset,skew];
            }
            llRezObject("Object",llGetPos(),<0,0,0>,<0,0,0,1>,1);
            llSay(19001,llDumpList2String(params,":"));
            if(params2 != []) llSay(19002,llDumpList2String(params2,":"));
            else llSay(19002,"done");
            params = [];
            params2 = [];
        }
    }
}
