/////////////////////////////////////////////////
//                                             //
//            Created  by Jeff Cost            //
//            http://myopengrid.com            //
//                 License MIT                 //
//                                             //
///////////////////////////////////////////////// 

string TITLE=" ";
vector focus = <98.448151, 121.155144, 27.112431>;
vector pos = <75.0,115.0,28.0>;
vector offset=<0.0,0.0,0.5>;      
string ANIMATION;
integer visible = TRUE;
key avatar;
vector COLOR = <1.0,1.0,1.0>;
float ALPHA_ON = 1.0;
float ALPHA_OFF = 0.0;

setCameraPosition(integer perms)
{
    if(perms & PERMISSION_CONTROL_CAMERA)
    {
        vector camPos = pos;
        vector camFocus = focus;
        llClearCameraParams();
        llSetCameraParams([
            CAMERA_ACTIVE, 1,
            CAMERA_FOCUS, camFocus,
            CAMERA_FOCUS_LOCKED, TRUE,
            CAMERA_POSITION, camPos,
            CAMERA_POSITION_LOCKED, TRUE
        ]);
    }
}

show(){
    visible = FALSE;
    llSetText("", COLOR,ALPHA_ON);        
    llSetAlpha(ALPHA_OFF, ALL_SIDES);
}

hide(){
    visible = FALSE;
    llSetText("", COLOR,ALPHA_ON);        
    llSetAlpha(ALPHA_OFF, ALL_SIDES);
}

default{
    state_entry() {
        llSitTarget(offset,ZERO_ROTATION);
        if((ANIMATION = llGetInventoryName(INVENTORY_ANIMATION,0)) == ""){
            llOwnerSay("Error: No animation");
            ANIMATION = "Lecture";
            }
        llSetSitText(TITLE);
        show();
    }

    touch_start(integer detected) {
        //llOwnerSay("Memory: " + (string)llGetFreeMemory());
        if(visible){ hide(); }
        else       { show(); }
    }

    changed(integer change) {
        if(change & CHANGED_LINK) {
            avatar = llAvatarOnSitTarget();
            if(avatar != NULL_KEY){
                //SOMEONE SAT DOWN
                hide();
                llRequestPermissions(avatar,PERMISSION_TRIGGER_ANIMATION | PERMISSION_CONTROL_CAMERA);
                return;
            }else{
                //SOMEONE STOOD UP
                if (llGetPermissionsKey() != NULL_KEY){ llStopAnimation(ANIMATION); }
                show();
                return;
            }
        }
        if(change & CHANGED_INVENTORY) { llResetScript(); }
        if(change & CHANGED_OWNER)     { llResetScript(); }
    }

    run_time_permissions(integer perm) {
        setCameraPosition(perm);
        if(perm & PERMISSION_TRIGGER_ANIMATION) {
            llStopAnimation("sit");
            llStartAnimation(ANIMATION);
            
            hide();
        }
    }
}