integer channel; // = 1000;
integer listener; // handle for temporary listener for question
integer yes;
integer no;
string question = "Do you confess to the crime?";
list voted; // list of ppl that's already voted

refreshText()
{
    llSetText(" - Prisoner's Dilemma - \n (click to answer) \n \n "+question+" \n Yes: "+(string)yes+"\n No: "+(string)no+"\n",<5,5,5>,5);
}

default
{
    state_entry()
    {
        //     llListen(channel,"", "","");
        //     llListen(22,"","","");
        //     llListen(21,"","","");
        channel = (integer)llFrand(10000);
        llListen(channel,"","","");
        refreshText();
    }

    touch_start(integer total_number)
    {
        string new_name =  llKey2Name(llDetectedKey(0));

        if (llDetectedKey(0) == llGetOwner())
        {
            if (llListFindList( voted, [new_name] ) != -1)
             {
                 llDialog(llDetectedKey(0),question+"\n\nPlease choose one of the below options.",["Reset","Question"],channel);
                }
                else
                {
            llDialog(llDetectedKey(0),question+"\n\nPlease choose one of the below options.",["Yes", "No","Reset","Question"],channel);
                }
        }

        if (llListFindList( voted, [new_name] ) != -1)
        {
            llInstantMessage(llDetectedKey(0),new_name+" you've already voted on this question. Thankyou!");
        }
        else
        {
            if (llDetectedKey(0) != llGetOwner())
            llDialog(llDetectedKey(0),question+"\n\nPlease choose one of the below options.",["Yes", "No"],channel);

        }
    }

    listen(integer chan, string name, key id, string mes)
    {

        if (id == llGetOwner() && listener != 0)
        {
            if (chan==0)
            {
                // new question. 
                question = mes;
                llListenRemove(listener);
                llOwnerSay("Question Changed");
                refreshText();
            }

        }

        if (chan==channel)
        {
            if (mes == "Yes")
            {
                yes = 1 + yes;
                llSay(0,"Thanks for your vote "+name+" it's been added to the tally");
                voted += llKey2Name(id);
            }
            
            else if (mes == "No")
            {
                no = 1 + no;
                llSay(0,"Thanks for your vote "+name+" it's been added to the tally");
                voted += llKey2Name(id);
            }
            else if (mes == "Reset")
            {
                // reset
                llDialog(llGetOwner(),"Are you sure you would like to reset the script?",["OK","No"],channel);  
            }
            else if (mes == "Question")
            {
                // Add new question
                // Open channel to listen for question.
                listener = llListen(0,"",llGetOwner(),"");
                llOwnerSay("Type your new question now.");
            }
            else if (mes == "OK")
            {
                // Owner has given the OK to reset
                    voted = [];
                    yes = 0;
                    no = 0;
                    llOwnerSay("Voting Names and Tally Reset");
                    refreshText();
            }

            refreshText();
        }
    }


}
