/*Page Number Script

Listens to the right and left arrows for a command to increment or decrement

*/

/*To customize - 
    set totalPages to the total number of pages in the slideshow
    */


                            
integer currentPageNumber = 1;  //the page the slideshow is on,
                                //starts at one for obvious reasons
                                
integer totalPages = 3;  //the total number of pages/textures the prim will shuffle through.                                
            

setPageNumber(integer direction)
{
    if (direction == -1) //we're decrementing
    {
        if (currentPageNumber == 1) //that is, of course, unless we are on the first page
        {
            currentPageNumber = totalPages;
        } 
        else 
        {
            currentPageNumber--;
        }
    } 
    else if (direction == 1) //we're incrementing
    {
        if(currentPageNumber == totalPages) //that is, of course, unless we are on the last page
        {
            currentPageNumber = 1;
        }
        else
        {
            currentPageNumber++;
        }
    }
    
    string page = "page" + (string)currentPageNumber;
    
    /*llSetPrimitiveParams([
        //Param to set, face, name of texture to set to,
            // repeats, offsets, rotation (a float, for some reason)
        PRIM_TEXTURE, ALL_SIDES, page , <1,1,1>, ZERO_VECTOR, 0.0
        ]); */
    llSetTexture(page, 1);
}
                            
default
{
    on_rez(integer i)
    {
        setPageNumber(0); //set the page to the default on rez
    }
    
    state_entry()
    {
        setPageNumber(0); //set the page to the default on state_entry
    }
    

    
    link_message(integer sender_num, integer num, string msg, key id)
    {
        if( llToLower(msg) == "increment" )
        {
            setPageNumber(1); //means set page number to itself +1
        }
        else if( llToLower(msg) == "decrement" )
        {
            setPageNumber(-1); //means set page number to itself -1
        } 
    }
}